% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmm_viterbi.R
\name{hmm_viterbi}
\alias{hmm_viterbi}
\title{Hidden Markov Model (HMM) Viterbi State Prediction}
\usage{
hmm_viterbi(input, input_model, verbose = getOption("mlpack.verbose", FALSE))
}
\arguments{
\item{input}{Matrix containing observations (numeric matrix).}

\item{input_model}{Trained HMM to use (HMMModel).}

\item{verbose}{Display informational messages and the full list of
parameters and timers at the end of execution.  Default value
"getOption("mlpack.verbose", FALSE)" (logical).}
}
\value{
A list with several components:
\item{output}{File to save predicted state sequence to (integer
  matrix).}
}
\description{
A utility for computing the most probable hidden state sequence for Hidden
Markov Models (HMMs).  Given a pre-trained HMM and an observed sequence, this
uses the Viterbi algorithm to compute and return the most probable hidden
state sequence.
}
\details{
This utility takes an already-trained HMM, specified as "input_model", and
evaluates the most probable hidden state sequence of a given sequence of
observations (specified as '"input", using the Viterbi algorithm.  The
computed state sequence may be saved using the "output" output parameter.
}
\examples{
# For example, to predict the state sequence of the observations "obs" using
# the HMM "hmm", storing the predicted state sequence to "states", the
# following command could be used:

\dontrun{
output <- hmm_viterbi(input=obs, input_model=hmm)
states <- output$output
}
}
\author{
mlpack developers
}
