% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureSimple.R
\name{mlr_measures_sim.jaccard}
\alias{mlr_measures_sim.jaccard}
\title{Jaccard Similarity Index}
\description{
Measure to compare two or more sets w.r.t. their similarity.
}
\details{
For two sets \eqn{A} and \eqn{B}, the Jaccard Index is defined as
\deqn{
  J(A, B) = \frac{|A \cap B|}{|A \cup B|}.
}{
  J(A, B) = length(intersect(A, B)) / length(union(A, B)).
}
If more than two sets are provided, the mean of all pairwise scores
is calculated.

This measure is undefined if two or more sets are empty.
}
\note{
This measure requires learners with property \code{"selected_features"}.
The extracted feature sets are passed to \code{\link[mlr3measures:jaccard]{mlr3measures::jaccard()}} from
package \CRANpkg{mlr3measures}.

If the measure is undefined for the input, \code{NaN} is returned.
This can be customized by setting the field \code{na_value}.
}
\section{Parameters}{

Empty ParamSet
}

\section{Dictionary}{

This \link{Measure} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_measures} or with the associated sugar function \code{\link[=msr]{msr()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_measures$get("sim.jaccard")
msr("sim.jaccard")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{


\itemize{
\item Type: \code{"similarity"}
\item Range: \eqn{[0, 1]}{[0, 1]}
\item Minimize: \code{FALSE}
}

}

\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Measure]{Measures}: \link{mlr_measures}

\code{as.data.table(mlr_measures)} for a complete table of all (also dynamically created) \link{Measure} implementations.

Other similarity measures: 
\code{\link{mlr_measures_sim.phi}}
}
\concept{similarity measures}
