% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionData.R, R/PredictionDataClassif.R,
%   R/PredictionDataRegr.R
\name{PredictionData}
\alias{PredictionData}
\alias{create_empty_prediction_data}
\alias{check_prediction_data}
\alias{is_missing_prediction_data}
\alias{filter_prediction_data}
\alias{check_prediction_data.PredictionDataClassif}
\alias{is_missing_prediction_data.PredictionDataClassif}
\alias{c.PredictionDataClassif}
\alias{check_prediction_data.PredictionDataRegr}
\alias{is_missing_prediction_data.PredictionDataRegr}
\alias{c.PredictionDataRegr}
\title{Convert to PredictionData}
\usage{
create_empty_prediction_data(task, learner)

check_prediction_data(pdata, ...)

is_missing_prediction_data(pdata, ...)

filter_prediction_data(pdata, row_ids, ...)

\method{check_prediction_data}{PredictionDataClassif}(pdata, train_task, ...)

\method{is_missing_prediction_data}{PredictionDataClassif}(pdata, ...)

\method{c}{PredictionDataClassif}(..., keep_duplicates = TRUE)

\method{check_prediction_data}{PredictionDataRegr}(pdata, ...)

\method{is_missing_prediction_data}{PredictionDataRegr}(pdata, ...)

\method{c}{PredictionDataRegr}(..., keep_duplicates = TRUE)
}
\arguments{
\item{task}{(\link{Task}).}

\item{learner}{(\link{Learner}).}

\item{pdata}{(\link{PredictionData})\cr
Named list inheriting from \code{"PredictionData"}.}

\item{...}{(one or more \link{PredictionData} objects).}

\item{row_ids}{\code{integer()}\cr
Row indices.}

\item{train_task}{(\link{Task})\cr
Task used for training the learner.}

\item{keep_duplicates}{(\code{logical(1)})
If \code{TRUE}, the combined \link{PredictionData} object is filtered for duplicated
row ids (starting from last).}
}
\description{
Objects of type \code{PredictionData} serve as a intermediate representation for objects of type \link{Prediction}.
It is an internal data structure, implemented to optimize runtime and solve some issues emerging while serializing R6 objects.
End-users typically do not need to worry about the details, package developers are advised to continue reading for some technical information.

Unlike most other \CRANpkg{mlr3} objects, \code{PredictionData} relies on the S3 class system.
The following operations must be supported to extend mlr3 for new task types:
\itemize{
\item \code{\link[=as_prediction_data]{as_prediction_data()}} converts objects to class \code{PredictionData}, e.g. objects of type \link{Prediction}.
\item \code{\link[=as_prediction]{as_prediction()}} converts objects to class \link{Prediction}, e.g. objects of type \code{PredictionData}.
\item \code{check_prediction_data()} is called on the return value of the predict method of a \link{Learner} to perform assertions and type conversions.
Returns an update object of class \code{PredictionData}.
\item \code{is_missing_prediction_data()} is used for the fallback learner (see \link{Learner}) to impute missing predictions. Returns vector with row ids which need imputation.
}
}
