% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ObjectiveFSelect.R
\name{ObjectiveFSelect}
\alias{ObjectiveFSelect}
\title{Class for Feature Selection Objective}
\description{
Stores the objective function that estimates the performance of feature subsets.
This class is usually constructed internally by the \link{FSelectInstanceBatchSingleCrit} / \link{FSelectInstanceBatchMultiCrit}.
}
\section{Super class}{
\code{\link[bbotk:Objective]{bbotk::Objective}} -> \code{ObjectiveFSelect}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{task}}{(\link[mlr3:Task]{mlr3::Task}).}

\item{\code{learner}}{(\link[mlr3:Learner]{mlr3::Learner}).}

\item{\code{resampling}}{(\link[mlr3:Resampling]{mlr3::Resampling}).}

\item{\code{measures}}{(list of \link[mlr3:Measure]{mlr3::Measure}).}

\item{\code{store_models}}{(\code{logical(1)}).}

\item{\code{store_benchmark_result}}{(\code{logical(1)}).}

\item{\code{callbacks}}{(List of \link{CallbackBatchFSelect}s).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ObjectiveFSelect-new}{\code{ObjectiveFSelect$new()}}
\item \href{#method-ObjectiveFSelect-clone}{\code{ObjectiveFSelect$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="eval"><a href='../../bbotk/html/Objective.html#method-Objective-eval'><code>bbotk::Objective$eval()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="eval_dt"><a href='../../bbotk/html/Objective.html#method-Objective-eval_dt'><code>bbotk::Objective$eval_dt()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="eval_many"><a href='../../bbotk/html/Objective.html#method-Objective-eval_many'><code>bbotk::Objective$eval_many()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="format"><a href='../../bbotk/html/Objective.html#method-Objective-format'><code>bbotk::Objective$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="help"><a href='../../bbotk/html/Objective.html#method-Objective-help'><code>bbotk::Objective$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="print"><a href='../../bbotk/html/Objective.html#method-Objective-print'><code>bbotk::Objective$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ObjectiveFSelect-new"></a>}}
\if{latex}{\out{\hypertarget{method-ObjectiveFSelect-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ObjectiveFSelect$new(
  task,
  learner,
  resampling,
  measures,
  check_values = TRUE,
  store_benchmark_result = TRUE,
  store_models = FALSE,
  callbacks = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{(\link[mlr3:Task]{mlr3::Task})\cr
Task to operate on.}

\item{\code{learner}}{(\link[mlr3:Learner]{mlr3::Learner})\cr
Learner to optimize the feature subset for.}

\item{\code{resampling}}{(\link[mlr3:Resampling]{mlr3::Resampling})\cr
Resampling that is used to evaluated the performance of the feature subsets.
Uninstantiated resamplings are instantiated during construction so that all feature subsets are evaluated on the same data splits.
Already instantiated resamplings are kept unchanged.}

\item{\code{measures}}{(list of \link[mlr3:Measure]{mlr3::Measure})\cr
Measures to optimize.
If \code{NULL}, \CRANpkg{mlr3}'s default measure is used.}

\item{\code{check_values}}{(\code{logical(1)})\cr
Check the parameters before the evaluation and the results for
validity?}

\item{\code{store_benchmark_result}}{(\code{logical(1)})\cr
Store benchmark result in archive?}

\item{\code{store_models}}{(\code{logical(1)}).
Store models in benchmark result?}

\item{\code{callbacks}}{(list of \link{CallbackBatchFSelect})\cr
List of callbacks.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ObjectiveFSelect-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ObjectiveFSelect-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ObjectiveFSelect$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
