% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpTorchFn.R
\name{mlr_pipeops_nn_fn}
\alias{mlr_pipeops_nn_fn}
\alias{PipeOpTorchFn}
\title{Custom Function}
\description{
Applies a user-supplied function to a tensor.
}
\section{Parameters}{

By default, these are inferred as all but the first arguments of the function \code{fn}.
It is also possible to specify these more explicitly via the \code{param_set} constructor argument.
}

\section{Input and Output Channels}{

One input channel called \code{"input"} and one output channel called \code{"output"}.
For an explanation see \code{\link{PipeOpTorch}}.
}

\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
custom_fn =  function(x, a) x / a
obj = po("nn_fn", fn = custom_fn, a = 2)
obj$param_set

graph = po("torch_ingress_ltnsr") \%>>\% obj

task = tsk("lazy_iris")$filter(1)
tnsr = materialize(task$data()$x)[[1]]

md_trained = graph$train(task)
trained = md_trained[[1]]$graph$train(tnsr)

trained[[1]]

custom_fn(tnsr, a = 2)
\dontshow{\}) # examplesIf}
}
\section{Super classes}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{\link[mlr3torch:PipeOpTorch]{mlr3torch::PipeOpTorch}} -> \code{PipeOpTorchFn}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipeOpTorchFn-new}{\code{PipeOpTorchFn$new()}}
\item \href{#method-PipeOpTorchFn-clone}{\code{PipeOpTorchFn$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3torch" data-topic="PipeOpTorch" data-id="shapes_out"><a href='../../mlr3torch/html/PipeOpTorch.html#method-PipeOpTorch-shapes_out'><code>mlr3torch::PipeOpTorch$shapes_out()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpTorchFn-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpTorchFn-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \code{\link[R6:R6Class]{R6}} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpTorchFn$new(
  fn,
  id = "nn_fn",
  param_vals = list(),
  param_set = NULL,
  shapes_out = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fn}}{(\code{function})\cr
The function to be applied. Takes a \code{torch} tensor as first argument and returns a \code{torch} tensor.}

\item{\code{id}}{(\code{character(1)})\cr
Identifier of the resulting  object.}

\item{\code{param_vals}}{(\code{list()})\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would
otherwise be set during construction.}

\item{\code{param_set}}{(\code{\link[paradox:ParamSet]{ParamSet}} or \code{NULL})\cr
A ParamSet wrapping the arguments to \code{fn}.
If omitted, then the ParamSet for this PipeOp will be inferred from the function signature.}

\item{\code{shapes_out}}{(\code{function} or \code{NULL})\cr
A function that computes the output shapes of the \code{fn}. See
\link{PipeOpTorch}'s \code{.shapes_out()} method for details on the parameters,
and \link{PipeOpTaskPreprocTorch} for details on how the shapes are inferred when
this parameter is \code{NULL}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpTorchFn-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpTorchFn-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpTorchFn$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
