% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmcif-pd.R
\name{mmcif_pd_cond}
\alias{mmcif_pd_cond}
\alias{mmcif_pd_bivariate}
\title{Computes Marginal Measures Using Two Observations}
\usage{
mmcif_pd_cond(
  par,
  object,
  newdata,
  cause,
  time,
  left_trunc = NULL,
  ghq_data = object$ghq_data,
  strata = NULL,
  which_cond,
  type_cond = "derivative",
  type_obs = "cumulative"
)

mmcif_pd_bivariate(
  par,
  object,
  newdata,
  cause,
  time,
  left_trunc = NULL,
  ghq_data = object$ghq_data,
  strata = NULL,
  use_log = FALSE,
  type = c("cumulative", "cumulative")
)
}
\arguments{
\item{par}{numeric vector with the model parameters.}

\item{object}{an object from \code{\link{mmcif_data}}.}

\item{newdata}{a \code{data.frame} with data for the observations. It needs
to have two rows.}

\item{cause}{an integer vector with the cause of each outcome. If there are
\code{n_causes} of outcome, then the vector should have values in
\code{1:(n_causes + 1)} with \code{n_causes + 1} indicating censoring.}

\item{time}{a numeric vector with the observed times.}

\item{left_trunc}{numeric vector with left-truncation times. \code{NULL}
implies that there are not any individuals with left-truncation.}

\item{ghq_data}{the Gauss-Hermite quadrature nodes and weights to
use. It should be a list with two elements called \code{"node"}
and \code{"weight"}. A default is provided if \code{NULL} is passed.}

\item{strata}{an integer vector or a factor vector with the strata of each
individual. \code{NULL} implies that there are no strata.}

\item{which_cond}{an integer with value one or two for the index of the
individual that is being conditioned on.}

\item{type_cond}{a character for the type of outcome that is being
conditioned on.
\code{"derivative"} for the derivative of a CIF or
\code{"cumulative"} for a CIF or the survival probability.}

\item{type_obs}{a character the type of conditional measure. It can be
\code{"derivative"} for the derivative of a CIF,
\code{"cumulative"} for a CIF or the survival probability, and
\code{"hazard"} for the hazard.}

\item{use_log}{a logical for whether the returned output should be on the
log scale.}

\item{type}{a 2D character vector for the type of measures for each
observation. The elements can be
\code{"derivative"} for the derivative of a CIF or
\code{"cumulative"} for a CIF or the survival probability.}
}
\value{
A numeric scalar with the requested quantity.
}
\description{
Computes bivariate figures such as conditional CIFs, survival probabilities,
and  hazards or bivariate CIFs, densities, and survival probabilities.
}
\examples{
if(require(mets)){
  data(prt)

  # truncate the time
  max_time <- 90
  prt <- within(prt, {
    status[time >= max_time] <- 0
    time <- pmin(time, max_time)
  })

  # select the DZ twins and re-code the status
  prt_use <- subset(prt, zyg == "DZ") |>
    transform(status = ifelse(status == 0, 3L, status))

  # Gauss Hermite quadrature nodes and weights from fastGHQuad::gaussHermiteData
  ghq_data <- list(
    node = c(-3.43615911883774, -2.53273167423279, -1.75668364929988, -1.03661082978951,
             -0.342901327223705, 0.342901327223705, 1.03661082978951, 1.75668364929988,
             2.53273167423279, 3.43615911883774),
    weight = c(7.6404328552326e-06, 0.00134364574678124, 0.0338743944554811, 0.240138611082314,
               0.610862633735326,0.610862633735326, 0.240138611082315, 0.033874394455481,
               0.00134364574678124, 7.64043285523265e-06))

  # setup the object for the computation
  mmcif_obj <- mmcif_data(
    ~ country - 1, prt_use, status, time, id, max_time,
    2L, strata = country, ghq_data = ghq_data)

  # previous estimates
  par <- c(0.727279974859164, 0.640534073288067, 0.429437766165371, 0.434367104339573,
           -2.4737847536253, -1.49576564624673, -1.89966050143904, -1.58881346649412,
           -5.5431198001029, -3.5328359024178, -5.82305147022587, -3.4531896212114,
           -5.29132887832377, -3.36106297109548, -6.03690322125729, -3.49516746825624,
           2.55000711185704, 2.71995985605891, 2.61971498736444, 3.05976391058032,
           -5.97173564860957, -3.37912051983482, -5.14324860374941, -3.36396780694965,
           -6.02337246348561, -3.03754644968859, -5.51267338700737, -3.01148582224673,
           2.69665543753264, 2.59359057553995, 2.7938341786374, 2.70689750644755,
           -0.362056555418564, 0.24088005091276, 0.124070380635372, -0.246152029808377,
           -0.0445628476462479, -0.911485513197845, -0.27911988106887, -0.359648419277058,
           -0.242711959678559, -6.84897302527358)

  # the test data we will use
  test_dat <- data.frame(
    country = factor(c("Norway", "Norway"), levels(prt_use$country)),
    status = c(1L, 2L), time = c(60, 75))

  # probability that both experience the event prior to the two times
  mmcif_pd_bivariate(
    par = par, object = mmcif_obj, newdata = test_dat, cause = status,
    strata = country, ghq_data = ghq_data, time = time, type =
      c("cumulative", "cumulative")) |>
    print()

  # density that one experiences an event at the point and the other
  # experiences an event prior to the point
  mmcif_pd_bivariate(
    par = par, object = mmcif_obj, newdata = test_dat, cause = status,
    strata = country, ghq_data = ghq_data, time = time, type =
      c("derivative", "cumulative")) |>
    print()

  # probability that both survive up to the passed points
  mmcif_pd_bivariate(
    par = par, object = mmcif_obj, newdata = test_dat, cause = c(3L, 3L),
    strata = country, ghq_data = ghq_data, time = time, type =
      c("cumulative", "cumulative")) |>
    print()

  # conditional hazard given that the other experiences an event prior to time
  mmcif_pd_cond(
    par = par, object = mmcif_obj, newdata = test_dat, cause = status,
    strata = country, ghq_data = ghq_data, time = time, which_cond = 1L,
    type_cond = "cumulative", type_obs = "hazard") |>
    print()

  # conditional CIF given that the other experiences an event prior to the
  # time
  mmcif_pd_cond(
    par = par, object = mmcif_obj, newdata = test_dat, cause = c(2L, 2L),
    strata = country, ghq_data = ghq_data, time = time, which_cond = 1L,
    type_cond = "cumulative", type_obs = "cumulative") |>
    print()

  # same but given that the other experiences the event at the point
  mmcif_pd_cond(
    par = par, object = mmcif_obj, newdata = test_dat, cause = c(2L, 2L),
    strata = country, ghq_data = ghq_data, time = time, which_cond = 1L,
    type_cond = "derivative", type_obs = "cumulative") |>
    print()
}

}
\seealso{
\code{\link{mmcif_pd_univariate}} and \code{\link{mmcif_fit}}.
}
