% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmtree-methods.R
\name{predict.pmtree}
\alias{predict.pmtree}
\title{pmtree predictions}
\usage{
\method{predict}{pmtree}(
  object,
  newdata = NULL,
  type = "node",
  predict_args = list(),
  perm = NULL,
  ...
)
}
\arguments{
\item{object}{pmtree object.}

\item{newdata}{an optional data frame in which to look for variables with
which to predict, if omitted, \code{object$data} is used.}

\item{type}{character denoting the type of predicted value. The terminal node 
is returned for \code{"node"}. If \code{type = "pass"} the model 
predict method is used and arguments can be passed to it via \code{predict_args}.
If \code{type = "coef"} the the model coefficients are returned.}

\item{predict_args}{If \code{type = "pass"} arguments can be passed on to the
model predict function.}

\item{perm}{an optional character vector of variable names (or integer vector 
of variable location in \code{newdata}). Splits of nodes 
with a primary split in any of these variables will be permuted (after dealing 
with surrogates). Note that surrogate split in the perm variables will no be 
permuted.}

\item{...}{passed on to predict.party (e.g. \code{perm}).}
}
\value{
predictions
}
\description{
Compute predictions from pmtree object.
}
\examples{


if(require("psychotools")) {
  data("MathExam14W", package = "psychotools")
  
  ## scale points achieved to [0, 100] percent
  MathExam14W$tests <- 100 * MathExam14W$tests/26
  MathExam14W$pcorrect <- 100 * MathExam14W$nsolved/13
  
  ## select variables to be used
  MathExam <- MathExam14W[ , c("pcorrect", "group", "tests", "study",
                               "attempt", "semester", "gender")]
  
  ## compute base model
  bmod_math <- lm(pcorrect ~ group, data = MathExam)
  lm_plot(bmod_math, densest = TRUE)
  
  ## compute tree
  (tr_math <- pmtree(bmod_math, control = ctree_control(maxdepth = 2)))
  plot(tr_math, terminal_panel = node_pmterminal(tr_math, plotfun = lm_plot, 
                                                 confint = FALSE))
  plot(tr_math, terminal_panel = node_pmterminal(tr_math, plotfun = lm_plot, 
                                                 densest = TRUE,
                                                 confint = TRUE))
  
  ## predict
  newdat <- MathExam[1:5, ]
  
  # terminal nodes
  (nodes <- predict(tr_math, type = "node", newdata = newdat))
  
  # response
  (pr <- predict(tr_math, type = "pass", newdata = newdat))
  
  # response including confidence intervals, see ?predict.lm
  (pr1 <- predict(tr_math, type = "pass", newdata = newdat,
                  predict_args = list(interval = "confidence")))
}
}
