% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moderate.mediation.R
\name{modmed.plot}
\alias{modmed.plot}
\title{Visual Representation of the Causal Moderated Mediation Analysis Results}
\usage{
modmed.plot(
  object,
  effect,
  moderator,
  other.mod.disc.values = NULL,
  other.mod.cont.values = NULL,
  is.dist.moderator = FALSE,
  probs = c(0.1, 0.25, 0.5, 0.75, 0.9),
  ncore = 2
)
}
\arguments{
\item{object}{Output from the \code{modmed} function.}

\item{effect}{A character string indicating which causal effect to be plotted. effect can be specified as "TE", "TIE", "PIE", "PDE", "TDE", "INT", "TE.ref", "TIE.ref", "PIE.ref", "PDE.ref", "TDE.ref", "INT.ref", "TE.dif", "TIE.dif", "PIE.dif", "PDE.dif", "TDE.dif", or "INT.dif".}

\item{moderator}{A character string indicating which moderator to be plotted. It must be one of the moderators specified in the function of \code{modmed}.}

\item{other.mod.disc.values}{A vector of values of the other discrete moderators given which the conditional effect at each value of the specified moderator is estimated. The order of other.mod.disc.values should be the same as moderators.disc specified in the function of \code{modmed}, with the specified moderator removed if the specified moderator is discrete. If one does not want to condition some moderators on specific values, one may specify their values to be NA. NULL if there are no other discrete moderators.}

\item{other.mod.cont.values}{A vector of values of the other continuous moderators given which the conditional effect at each value of the specified moderator is estimated. The order of other.mod.cont.values should be the same as moderators.cont specified in the function of \code{modmed}, with the specified moderator removedif the specified moderator is continuous. If one does not want to condition some moderators on specific values, one may specify their values to be NA. NULL if there are no other continuous moderators.}

\item{is.dist.moderator}{A logical value. "TRUE" if distribution of the specified moderator is to be plotted at the bottom, and "FALSE" if not. The default is "FALSE".}

\item{probs}{A vector of percentiles to be plotted on the distribution of the moderator if the moderator is continuous. NULL if is.dist.moderator = FALSE. The default is c(0.1, 0.25, 0.5, 0.75, 0.9).}

\item{ncore}{The number of cores for parallel computing. The default is the number of CPU cores on the current host minus 1. One core is saved for users to run other programs on the computer while running the R function.}
}
\value{
\code{modmed} returns causal moderated mediation analysis results. The \code{plot.modmed} function plots the results.
}
\description{
'modmed.plot' is used to visualize results from \code{modmed} function. This applies only if moderators.disc or moderators.cont is not NULL. The plot consists of two parts. The top represents the sampling distribution of the specified causal effect as a function of the specified moderator within the given levels of the other moderators. The bottom represents the distribution of the specified moderator on the x axis.
}
\examples{
\donttest{
data(newws)
modmed.results = modmed(data = newws, treatment = "treat", mediator = "emp",
    outcome = "depression", covariates.disc = c("emp_prior", "nevmar",
        "hispanic", "nohsdip"), covariates.cont = c("workpref", "attitude",
        "depress_prior"), moderators.disc = "CHCNT", moderators.cont = "ADCPC",
    m.model = list(intercept = c("ADCPC", "CHCNT"), treatment = c("ADCPC",
        "CHCNT"), emp_prior = NULL, nevmar = NULL, hispanic = NULL,
        nohsdip = NULL, workpref = NULL, attitude = NULL, depress_prior = NULL),
    y.model = list(intercept = c("ADCPC", "CHCNT"), treatment = c("ADCPC",
        "CHCNT"), mediator = c("ADCPC", "CHCNT"), tm = c("ADCPC",
        "CHCNT"), emp_prior = NULL, nevmar = NULL, hispanic = NULL,
        nohsdip = NULL, workpref = NULL, attitude = NULL, depress_prior = NULL),
    comp.mod.disc.values = 3, ref.mod.disc.values = 2, comp.mod.cont.values = 5050,
    ref.mod.cont.values = 5050, m.scale = "binary", y.scale = "continuous",
    seed = 1)
modmed.plot(modmed.results, effect = "TIE", moderator = "ADCPC",
    other.mod.disc.values = 1, is.dist.moderator = TRUE, ncore = 1)
}
}
\references{
Qin, X., & Wang, L. (2023). Causal moderated mediation analysis: Methods and software
}
\author{
Xu Qin and Lijuan Wang
}
