% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iss.R
\name{query_iss}
\alias{query_iss}
\title{Submit a REST Query to ISS}
\usage{
query_iss(rest_path, params = list(), debug_output = getOption("moexer.debug"))
}
\arguments{
\item{rest_path}{A REST path appended to \code{iss_base_url}.}

\item{params}{A HTTP GET query parameters string, passed as a \code{list} (not
URL-escaped!)}

\item{debug_output}{Print REST URLs as they are queried.}
}
\value{
A list of tibbles, corresponding to the blocks in the response.
}
\description{
See \url{http://iss.moex.com/iss/reference/} for the list of available endpoints.
}
\examples{
\dontrun{
query_iss(
    rest_path = 'securities/SBER',
    params = list(iss.only = 'description'),
    debug_output = TRUE
)
}
}
