% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chr.disp.param.R
\name{chr.disp.param}
\alias{chr.disp.param}
\title{Simulate character displacement data wrapper}
\usage{
chr.disp.param(
  phy,
  n.sim = 100,
  n.steps = 1000,
  max.sigma = 8,
  max.a = 8,
  est.blomberg.k = FALSE,
  ntraits = 1,
  sympatry = NA,
  allopatry = NA,
  trait.lim = NA,
  mc.cores = 1
)
}
\arguments{
\item{phy}{An object of class \code{phylo} (see \pkg{ape}).}

\item{n.sim}{Number of replications to simulate data}

\item{n.steps}{Number of time steps the for the simulation (default = 1000 time steps).}

\item{max.sigma}{The maximum value of Brownian variance in the simulation sampled from a U(0, max.sigma) distribution for each iteration}

\item{max.a}{The maximum value of the strength of competition between inter-specific lineages sampled from a U(0, max.a) distribution for each iteration}

\item{est.blomberg.k}{Logical. If TRUE, Blomberg's K is simultaneously estimated}

\item{ntraits}{Number of traits to be simulated}

\item{sympatry}{an optional matrix giving the time that each pair of species starts to interact}

\item{allopatry}{an optional matrix giving the times when species stop interacting}

\item{trait.lim}{an optional parameter that puts limits on the available trait-space, preventing trait values with magnitude greater than the value of lim}

\item{mc.cores}{Numeric. The number of parallel cores to be used in simulations. Only applicable on Linux and Mac systems}
}
\value{
List containing the simulated data 'simulated.param': a matrix with each row represented an iteration, the sigma (Brownian variance) used in the iteration, the 'a' value used in each iteration, the mean and standard deviation between neighbouring trait values. The 'input.arguments' from the model, the 'input.phy' from the model, and the input 'sympatry' and 'allopatry' matrices.
}
\description{
Simulates phylogenetic trait data under a character displacement model (Clarke et al. 2017) in which traits interact inter-specifically, with competition between sympatric lineages driving trait values apart
}
\examples{
## import finch data form Clarke et al. (2017)
data(finches)
## simulate small amount of data 
## (example only - many more datasets are required for accuracy)
param.simulation <- chr.disp.param(finch.tree, n.sim = 3, n.steps=100,  
max.sigma = 8, max.a = 8, ntraits=1, 
allopatry=as.matrix(allopatric.data), mc.cores = 1)
}
\references{
Clarke M, Thomas GH, & Freckleton RP. 2017. Trait evolution in adaptive radiations: modeling and measuring interspecific competition on phylogenies. The American Naturalist 189, 121-137.
}
\seealso{
\code{\link{chr.disp.sim}}, \code{\link{chr.disp.lrt}}
}
\author{
Magnus Clarke and Mark Puttick
}
