% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movebank_handle.R
\name{movebank_handle}
\alias{movebank_handle}
\title{Create a curl handle for accessing movebank}
\usage{
movebank_handle(username = NULL, password = NULL)
}
\arguments{
\item{username}{Optionally a username as a character string}

\item{password}{Optionally a password as a character string}
}
\value{
A \code{\link[curl]{handle}} that can be added to a request made with \code{\link[curl]{curl}}
}
\description{
Create a curl handle for accessing movebank
}
\details{
If no credentials are provided the function tries to retrieve the username and password from the system
keyring using the keyring package. If a username is provided but no password it is requested using
\code{\link[askpass]{askpass}}
}
\examples{
movebank_handle("test_user", "test_password")
}
\seealso{
Other movebank-download: 
\code{\link{movebank_download_study}()},
\code{\link{movebank_store_credentials}()}
}
\concept{movebank-download}
