% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{apply_filter_sgolay}
\alias{apply_filter_sgolay}
\title{Apply a Savitzky-Golay filter to a view}
\usage{
apply_filter_sgolay(
  view,
  data_points,
  n,
  p,
  folder_out = "Filtered",
  save_output = FALSE
)
}
\arguments{
\item{view}{\code{View} object.}

\item{data_points}{body parts e.g. 'Nose'.}

\item{n}{window size.}

\item{p}{poly order.}

\item{folder_out}{output folder relative to recording home (default is 'Filtered').}

\item{save_output}{save the output?}
}
\value{
a \code{FilteredView} object.
}
\description{
Apply a Savitzky-Golay filter to a view
}
\examples{
r <- get_sample_recording()
rv <- get_raw_view(r, "Central", "", "Sitar")
pv <- get_processed_view(rv)

set.seed(1)
fv1 <- apply_filter_sgolay(pv, c("Nose", "RWrist", "LWrist"), n = 19, p = 4)
fv2 <- apply_filter_sgolay(pv, c("Nose", "RWrist", "LWrist"), n = 41, p = 3)

set.seed(1) # to reproduce with S3 filter object
fv3 <- apply_filter(pv, c("Nose", "RWrist", "LWrist"), signal::sgolay(4, 19))
}
\seealso{
Other data functions: 
\code{\link{get_data_points}()},
\code{\link{get_duration_annotation_data}()},
\code{\link{get_feature_data}()},
\code{\link{get_filtered_views}()},
\code{\link{get_joined_view}()},
\code{\link{get_metre_data}()},
\code{\link{get_onsets_selected_data}()},
\code{\link{get_processed_views}()},
\code{\link{get_processed_view}()},
\code{\link{get_raw_optflow_view}()},
\code{\link{get_raw_views}()},
\code{\link{get_raw_view}()},
\code{\link{get_recording}()},
\code{\link{get_sample_recording}()}
}
\concept{data functions}
