% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensor_functions.R
\name{get_data}
\alias{get_data}
\title{Extract data from an m-Path Sense database}
\usage{
get_data(db, sensor, participant_id = NULL, start_date = NULL, end_date = NULL)
}
\arguments{
\item{db}{A database connection to an m-Path Sense database.}

\item{sensor}{The name of a sensor. See \link[mpathsenser]{sensors} for a list of available
sensors.}

\item{participant_id}{A character string identifying a single participant. Use
\code{\link[mpathsenser]{get_participants}} to retrieve all participants from the database.
Leave empty to get data for all participants.}

\item{start_date}{Optional search window specifying date where to begin search. Must be
convertible to date using \link[base]{as.Date}. Use \link[mpathsenser]{first_date} to find the
date of the first entry for a participant.}

\item{end_date}{Optional search window specifying date where to end search. Must be convertible
to date using \link[base]{as.Date}. Use \link[mpathsenser]{last_date} to find the date of the
last entry for a participant.}
}
\value{
A lazy \code{\link[dplyr]{tbl}} containing the requested data.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This is a convenience function to help extract data from an m-Path sense database.
}
\details{
Note that this function returns a lazy (also called remote) \code{tibble}. This means that
the data is not actually in R until you call a function that pulls the data from the database.
This is useful for various functions in this package that work with a lazy tibble, for example
\code{\link[=identify_gaps]{identify_gaps()}}. You may manually want to modify this lazy \code{tibble} by using \code{dplyr}
functions such as \code{\link[dplyr:filter]{dplyr::filter()}} or \code{\link[dplyr:mutate]{dplyr::mutate()}} before pulling the data into R. These
functions will be executed in-database, and will therefore be much faster than having to first
pull all data into R and then possibly removing a large part of it. Importantly, data can
pulled into R using \code{\link[dplyr:compute]{dplyr::collect()}}.
}
\examples{
\dontrun{
# Open a database
db <- open_db()

# Retrieve some data
get_data(db, "Accelerometer", "12345")

# Or within a specific window
get_data(db, "Accelerometer", "12345", "2021-01-01", "2021-01-05")
}

}
