% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrCoOccurNet.R
\name{mrCoOccurNet}
\alias{mrCoOccurNet}
\title{Generate a MrIML co-occurrence network}
\usage{
mrCoOccurNet(mrBootstrap_obj)
}
\arguments{
\item{mrBootstrap_obj}{A list of bootstrapped partial dependencies output from
\code{\link[=mrBootstrap]{mrBootstrap()}}.}
}
\value{
A data frame representing the co-occurrence network with edge
strengths and directionality.
}
\description{
This function generates a co-occurrence network from a provided list and
calculates strength and directionality of the relationships. The output can be
passed to \pkg{igraph} to plot a directed acyclic graph (DAG).
}
\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(tidymodels)
library(igraph)
library(ggnetwork)

mrIML_rf <- mrIML::mrIML_bird_parasites_RF

mrIML_rf_boot <- mrIML_rf \%>\%
  mrBootstrap()

assoc_net_filtered <- mrIML_rf_boot \%>\%
  mrCoOccurNet() \%>\%
  filter(mean_strength > 0.05)

# Convert to igraph
g <- graph_from_data_frame(
  assoc_net_filtered,
  directed = TRUE,
  vertices = names(mrIML_rf$Data$Y)
)
E(g)$Value <- assoc_net_filtered$mean_strength
E(g)$Color <- ifelse(
  assoc_net_filtered$direction == "negative",
  "blue", "red"
)
# Convert the igraph object to a ggplot object with NMDS layout
gg <- ggnetwork(g)
# Plot the graph
ggplot(
  gg,
  aes(x = x, y = y, xend = xend, yend = yend)
) +
  geom_edges(
    aes(color = Color, linewidth = Value),
    curvature = 0.2,
    arrow = arrow(length = unit(5, "pt"), type = "closed")
  ) +
  geom_nodes(
    color = "gray",
    size = degree(g, mode = "out") / 2
  ) +
  scale_color_identity() +
  theme_void() +
  theme(legend.position = "none") +
  geom_nodelabel_repel(
    aes(label = name),
    box.padding = unit(0.5, "lines"),
    size = 2,
    segment.colour = "black",
    colour = "white",
    fill = "grey36"
  )
\dontshow{\}) # examplesIf}
}
