% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrVip.R
\name{mrVip}
\alias{mrVip}
\title{Calculates and helps interpret variable importance for \code{mrIML} models.}
\usage{
mrVip(
  mrIMLobj,
  mrBootstrap_obj = NULL,
  threshold = 0.1,
  global_top_var = 10,
  local_top_var = 5,
  taxa = NULL,
  model_perf = NULL
)
}
\arguments{
\item{mrIMLobj}{A list object output by \code{\link[=mrIMLpredicts]{mrIMLpredicts()}}.}

\item{mrBootstrap_obj}{A list of bootstrap results output by \code{\link[=mrBootstrap]{mrBootstrap()}}.}

\item{threshold}{The performance threshold for response models (AUC for
classification and R2 for regression). Only response models that meet this
performance criterion are plotted.}

\item{global_top_var}{The number of top global variables to display
(default: 10).}

\item{local_top_var}{The number of top local variables for each response to
display (default: 5).}

\item{taxa}{A character string identifying which response model should be
plotted.}

\item{model_perf}{A list object containing model performance metrics output
by \code{\link[=mrIMLperformance]{mrIMLperformance()}}. If not supplied, then \code{\link[=mrIMLperformance]{mrIMLperformance()}} is run
inside \code{mrvip()} to get performance metrics.}
}
\value{
A list containing:
\itemize{
\item \verb{$vi_data}: Variable importance data in its raw form (including bootstrap
samples if \code{mrBootstrap_obj} was supplied).
\item \verb{$vi_tbl}: Variable importance data point estimates.
\item \verb{$vi_plot}: A grouped plot of the most important variables both globally and
for the individual response models.
}
}
\description{
Summarizes variable importance in a \code{mrIML} model at both a global
(across all the response models) and local (for individual response models) level.
This can be done for a plain \code{mrIML} model or bootstrap results obtained from
\code{\link[=mrBootstrap]{mrBootstrap()}}.
}
\examples{
# Without bootstrap
mrIML_rf <- mrIML::mrIML_bird_parasites_RF

vip_results <-mrVip(mrIML_rf, taxa = "Plas")

# With bootstrap
\donttest{
mrIML_rf_boot <- mrIML_rf \%>\%
  mrBootstrap(num_bootstrap = 5)
  
mrIML_rf_vip <- mrVip(
  mrIML_rf,
  mrBootstrap_obj = mrIML_rf_boot
)
}
}
