% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.mvgam.R
\name{update.mvgam}
\alias{update.mvgam}
\alias{update.jsdgam}
\title{Update an existing \pkg{mvgam} model object}
\usage{
\method{update}{mvgam}(
  object,
  formula,
  trend_formula,
  knots,
  trend_knots,
  trend_model,
  family,
  share_obs_params,
  data,
  newdata,
  trend_map,
  use_lv,
  n_lv,
  priors,
  chains,
  burnin,
  samples,
  threads,
  algorithm,
  lfo = FALSE,
  ...
)

\method{update}{jsdgam}(
  object,
  formula,
  factor_formula,
  knots,
  factor_knots,
  data,
  newdata,
  n_lv,
  family,
  share_obs_params,
  priors,
  chains,
  burnin,
  samples,
  threads,
  algorithm,
  lfo = FALSE,
  ...
)
}
\arguments{
\item{object}{\code{list} object returned from \code{mvgam}. See \code{\link[=mvgam]{mvgam()}}}

\item{formula}{Optional new \code{formula} object. Note, \code{mvgam} currently does not support dynamic formula
updates such as removal of specific terms with \code{- term}. When updating, the entire formula needs
to be supplied}

\item{trend_formula}{An optional \code{formula} object specifying the GAM
process model formula. If
supplied, a linear predictor will be modelled for the latent trends to capture
process model evolution
separately from the observation model. Should not have a response variable
specified on the left-hand side
of the formula (i.e. a valid option would be \code{~ season + s(year)}). Also note
that you should not use
the identifier \code{series} in this formula to specify effects that vary across
time series. Instead you should use
\code{trend}. This will ensure that models in which a \code{trend_map} is supplied will
still work consistently
(i.e. by allowing effects to vary across process models, even when some time
series share the same underlying
process model). This feature is only currently available for \code{RW()}, \code{AR()}
and \code{VAR()} trend models.
In \code{nmix()} family models, the \code{trend_formula} is used to set up a linear
predictor for the underlying
latent abundance. Be aware that it can be very challenging to simultaneously
estimate intercept parameters
for both the observation mode (captured by \code{formula}) and the process model
(captured by \code{trend_formula}).
Users are recommended to drop one of these using the \code{- 1} convention in the
formula right hand side.}

\item{knots}{An optional \code{list} containing user specified knot values to
be used for basis construction.
For most bases the user simply supplies the knots to be used, which must match
up with the \code{k} value supplied
(note that the number of knots is not always just \code{k}). Different terms can
use different numbers of knots,
unless they share a covariate}

\item{trend_knots}{As for \code{knots} above, this is an optional \code{list} of
knot values for smooth
functions within the \code{trend_formula}}

\item{trend_model}{\code{character} or  \code{function} specifying the time
series dynamics for the latent trend. Options are:
\itemize{
\item \code{None} (no latent trend component; i.e. the GAM component is all that
contributes to the linear predictor, and the observation process is the only
source of error; similarly to what is estimated by \code{\link[mgcv]{gam}})
\item \code{ZMVN} or \code{ZMVN()} (Zero-Mean Multivariate Normal; only available in
\code{Stan})
\item \code{'RW'} or \code{RW()}
\item \code{'AR1'} or \code{AR(p = 1)}
\item \code{'AR2'} or \code{AR(p = 2)}
\item \code{'AR3'} or \code{AR(p = 3)}
\item \code{'CAR1'} or \code{CAR(p = 1)}
\item \code{'VAR1'}  or \code{VAR()}(only available in \code{Stan})
\item \verb{'PWlogistic}, \code{'PWlinear'} or \code{PW()} (only available in \code{Stan})
\item \code{'GP'} or \code{GP()} (Gaussian Process with squared exponential kernel;
only available in \code{Stan})}

For all trend types apart from \code{ZMVN()}, \code{GP()}, \code{CAR()} and \code{PW()}, moving
average and/or correlated process error terms can also be estimated (for
example, \code{RW(cor = TRUE)} will set up a multivariate Random Walk if \code{n_series > 1}).
It is also possible for many multivariate trends to estimate hierarchical
correlations if the data are structured among levels of a relevant grouping
factor. See \link{mvgam_trends} for more details and see \link{ZMVN} for an example.}

\item{family}{\code{family} specifying the exponential observation family for
the series. Currently supported
families are:
\itemize{
\item\code{gaussian()} for real-valued data
\item\code{betar()} for proportional data on \verb{(0,1)}
\item\code{lognormal()} for non-negative real-valued data
\item\code{student_t()} for real-valued data
\item\code{Gamma()} for non-negative real-valued data
\item\code{bernoulli()} for binary data
\item\code{poisson()} for count data
\item\code{nb()} for overdispersed count data
\item\code{binomial()} for count data with imperfect detection when the number
of trials is known;
note that the \code{cbind()} function must be used to bind the discrete
observations and the discrete number
of trials
\item\code{beta_binomial()} as for \code{binomial()} but allows for overdispersion
\item\code{nmix()} for count data with imperfect detection when the number of
trials is unknown and should be modeled via a State-Space N-Mixture model.
The latent states are Poisson, capturing the 'true' latent
abundance, while the observation process is Binomial to account for
imperfect detection.
See \code{\link{mvgam_families}} for an example of how to use this family}
Default is \code{poisson()}.
See \code{\link{mvgam_families}} for more details}

\item{share_obs_params}{\code{logical}. If \code{TRUE} and the \code{family}
has additional family-specific observation parameters (e.g. variance
components in
\code{student_t()} or \code{gaussian()}, or dispersion parameters in \code{nb()} or
\code{betar()}), these parameters will be shared across all outcome variables. This is handy
if you have multiple outcomes (time series in most \code{mvgam} models) that you
believe share some properties,
such as being from the same species over different spatial units. Default is
\code{FALSE}.}

\item{data}{A \code{dataframe} or \code{list} containing the model response
variable and covariates
required by the GAM \code{formula} and optional \code{trend_formula}. Most
models should include columns:
\itemize{
\item\code{series} (a \code{factor} index of the series IDs; the number of
levels should be identical
to the number of unique series labels (i.e. \code{n_series = length(levels(data$series))}))
\item\code{time} (\code{numeric} or \code{integer} index of the time point for
each observation).
For most dynamic trend types available in \code{mvgam} (see argument \code{trend_model}),
time should be
measured in discrete, regularly spaced intervals (i.e. \code{c(1, 2, 3, ...)}).
However you can
use irregularly spaced intervals if using \code{trend_model = CAR(1)}, though
note that any
temporal intervals that are exactly \code{0} will be adjusted to a very small number
(\code{1e-12}) to prevent sampling errors. See an example of \code{CAR()} trends in
\code{\link{CAR}}
}
Note however that there are special cases where these identifiers are not
needed. For
example, models with hierarchical temporal correlation processes (e.g.
\code{AR(gr = region, subgr = species)})
should NOT include a \code{series} identifier, as this will be constructed
internally (see
\code{\link{mvgam_trends}} and \code{\link{AR}} for details). \code{mvgam} can also
fit models that do not
include a \code{time} variable if there are no temporal dynamic structures included
(i.e. \code{trend_model = 'None'} or
\code{trend_model = ZMVN()}). \code{data} should also include any other variables to be
included in
the linear predictor of \code{formula}}

\item{newdata}{Optional \code{dataframe} or \code{list} of test data containing
the same variables
as in \code{data}. If included, the
observations in variable \code{y} will be set to \code{NA} when fitting the
model so that posterior
simulations can be obtained}

\item{trend_map}{Optional \code{data.frame} specifying which series should depend
on which latent trends. Useful for allowing multiple series to depend on the
same latent trend process, but with different observation processes. If
supplied, a latent factor model is set up by setting \code{use_lv = TRUE} and
using the mapping to set up the shared trends. Needs to have column names
\code{series} and \code{trend}, with integer values in the \code{trend} column to state which
trend each series should depend on. The \code{series} column should have a single
unique entry for each series in the data (names should perfectly match factor
levels of the \code{series} variable in \code{data}). Note that if this is supplied,
the intercept parameter in the process model will NOT be automatically suppressed.
Not yet supported for models in wich the latent factors evolve in continuous time (\code{CAR()}).
See examples for details}

\item{use_lv}{\code{logical}. If \code{TRUE}, use dynamic factors to estimate series'
latent trends in a reduced dimension format. Only available for
\code{RW()}, \code{AR()} and \code{GP()} trend models. Defaults to \code{FALSE}}

\item{n_lv}{\code{integer} the number of latent dynamic factors to use if
\code{use_lv == TRUE}. Cannot be \code{> n_series}. Defaults arbitrarily to
\code{min(2, floor(n_series / 2))}}

\item{priors}{An optional \code{data.frame} with prior
definitions or, preferentially, a vector containing
objects of class \code{brmsprior} (see. \code{\link[brms]{prior}} for details).
See \link{get_mvgam_priors} and Details' for more information on changing default prior distributions}

\item{chains}{\code{integer} specifying the number of parallel chains for the model. Ignored
if \code{algorithm \%in\% c('meanfield', 'fullrank', 'pathfinder', 'laplace')}}

\item{burnin}{\code{integer} specifying the number of warmup iterations of the Markov chain to run
to tune sampling algorithms. Ignored
if \code{algorithm \%in\% c('meanfield', 'fullrank', 'pathfinder', 'laplace')}}

\item{samples}{\code{integer} specifying the number of post-warmup iterations of the Markov chain to run for
sampling the posterior distribution}

\item{threads}{\code{integer} Experimental option to use multithreading for within-chain
parallelisation in \code{Stan}. We recommend its use only if you are experienced with
\code{Stan}'s \code{reduce_sum} function and have a slow running model that cannot be sped
up by any other means. Currently works for all families apart from \code{nmix()} and
when using \code{Cmdstan} as the backend}

\item{algorithm}{Character string naming the estimation approach to use.
Options are \code{"sampling"} for MCMC (the default), \code{"meanfield"} for
variational inference with factorized normal distributions,
\code{"fullrank"} for variational inference with a multivariate normal
distribution, \code{"laplace"} for a Laplace approximation (only available
when using cmdstanr as the backend) or \code{"pathfinder"} for the pathfinder
algorithm (only currently available when using cmdstanr as the backend).
Can be set globally for the current \R session via the
\code{"brms.algorithm"} option (see \code{\link{options}}). Limited testing
suggests that \code{"meanfield"} performs best out of the non-MCMC approximations for
dynamic GAMs, possibly because of the difficulties estimating covariances among the
many spline parameters and latent trend parameters. But rigorous testing has not
been carried out}

\item{lfo}{Logical indicating whether this is part of a call to \link{lfo_cv.mvgam}. Returns a
lighter version of the model with no residuals and fewer monitored parameters to speed up
post-processing. But other downstream functions will not work properly, so users should always
leave this set as \code{FALSE}}

\item{...}{Other arguments to be passed to \code{\link{mvgam}} or \code{\link{jsdgam}}}

\item{factor_formula}{Optional new \code{formula} object for the factor linear predictors}

\item{factor_knots}{An optional \code{list} containing user specified knot values to
be used for basis construction of any smooth terms in \code{factor_formula}.
For most bases the user simply supplies the knots to be used, which must match up with the \code{k} value supplied
(note that the number of knots is not always just \code{k}). Different terms can use different numbers of knots,
unless they share a covariate}
}
\value{
A \code{list} object of class \code{mvgam} containing model output, the text representation of the model file,
the mgcv model output (for easily generating simulations at
unsampled covariate values), Dunn-Smyth residuals for each outcome variable and key information needed
for other functions in the package. See \code{\link{mvgam-class}} for details.
Use \code{methods(class = "mvgam")} for an overview on available methods.

A \code{list} object of class \code{mvgam} containing model output, the text representation of the model file,
the mgcv model output (for easily generating simulations at
unsampled covariate values), Dunn-Smyth residuals for each series and key information needed
for other functions in the package. See \code{\link{mvgam-class}} for details.
Use \code{methods(class = "mvgam")} for an overview on available methods.
}
\description{
This function allows a previously fitted \pkg{mvgam} model to be updated
}
\examples{
\donttest{
# Simulate some data and fit a Poisson AR1 model
simdat <- sim_mvgam(n_series = 1, trend_model = AR())
mod <- mvgam(y ~ s(season, bs = 'cc'),
             trend_model = AR(),
             noncentred = TRUE,
             data = simdat$data_train,
             chains = 2)
summary(mod)
conditional_effects(mod, type = 'link')

# Update to an AR2 model
updated_mod <- update(mod, trend_model = AR(p = 2),
                      noncentred = TRUE)
summary(updated_mod)
conditional_effects(updated_mod, type = 'link')

# Now update to a Binomial AR1 by adding information on trials
# requires that we supply newdata that contains the 'trials' variable
simdat$data_train$trials <- max(simdat$data_train$y) + 15
updated_mod <- update(mod,
                      formula = cbind(y, trials) ~ s(season, bs = 'cc'),
                      noncentred = TRUE,
                      data = simdat$data_train,
                      family = binomial())
summary(updated_mod)
conditional_effects(updated_mod, type = 'link')
}
}
\author{
Nicholas J Clark
}
