% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/team_match_stats.R
\name{team_match_stats}
\alias{team_match_stats}
\title{Extract team summary statistics for all matches in a particular season}
\usage{
team_match_stats(team_id = NULL, sport = "WVB")
}
\arguments{
\item{team_id}{Team ID determined by NCAA for season. To find ID, use
\code{\link[=find_team_id]{find_team_id()}}.}

\item{sport}{Three letter abbreviation for NCAA sport (must be upper case;
for example "WVB" for women's volleyball and "MVB" for men's volleyball).}
}
\value{
Returns a data frame of summary team statistics for each match of the season.
}
\description{
The NCAA's main page for a team includes a tab called "Game By Game"
and a section called "Game by Game Stats".
This function extracts the team's summary statistics for each match of the
season.
}
\note{
This function \strong{requires internet connectivity} as it checks the
\href{https://stats.ncaa.org}{NCAA website} for information.
It also uses the \href{https://rstudio.github.io/chromote/}{\code{{chromote}}} package
and \strong{requires \href{https://www.google.com/chrome/}{Google Chrome}} to be
installed.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
team_match_stats(team_id = "585290")
\dontshow{\}) # examplesIf}
}
\seealso{
Other functions that extract team statistics: 
\code{\link{team_season_info}()},
\code{\link{team_season_stats}()}
}
\concept{functions that extract team statistics}
