% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/krieger.R
\name{krieger}
\alias{krieger}
\title{Index of Concentration at the Extremes based on Feldman \emph{et al.} (2015) and Krieger \emph{et al.} (2016)}
\usage{
krieger(geo = "tract", year = 2020, quiet = FALSE, ...)
}
\arguments{
\item{geo}{Character string specifying the geography of the data either census tracts \code{geo = "tract"} (the default) or counties \code{geo = "county"}.}

\item{year}{Numeric. The year to compute the estimate. The default is 2020, and the years 2009 onward are currently available.}

\item{quiet}{Logical. If TRUE, will display messages about potential missing census information. The default is FALSE.}

\item{...}{Arguments passed to \code{\link[tidycensus]{get_acs}} to select state, county, and other arguments for census characteristics}
}
\value{
An object of class 'list'. This is a named list with the following components:

\describe{
\item{\code{ice}}{An object of class 'tbl' for the GEOID, name, ICE metrics, and raw census values of specified census geographies.}
\item{\code{missing}}{An object of class 'tbl' of the count and proportion of missingness for each census variable used to compute the ICEs.}
}
}
\description{
Compute the aspatial Index of Concentration at the Extremes (Krieger).
}
\details{
This function will compute three aspatial Index of Concentration at the Extremes (ICE) of U.S. census tracts or counties for a specified geographical extent (e.g., entire U.S. or a single state) based on Feldman \emph{et al.} (2015) \doi{10.1136/jech-2015-205728} and Krieger \emph{et al.} (2016) \doi{10.2105/AJPH.2015.302955}. The authors expanded the metric designed by Massey in a chapter of Booth & Crouter (2001) \doi{10.4324/9781410600141} who initially designed the metric for residential segregation. This function computes five ICE metrics:

\itemize{
\item \strong{Income}: 80th income percentile vs. 20th income percentile
\item \strong{Education}: less than high school vs. four-year college degree or more
\item \strong{Race/Ethnicity}: white non-Hispanic vs. black non-Hispanic
\item \strong{Income and race/ethnicity combined}: white non-Hispanic in 80th income percentile vs. black alone (including Hispanic) in 20th income percentile
\item \strong{Income and race/ethnicity combined}: white non-Hispanic in 80th income percentile vs. white non-Hispanic in 20th income percentile
}

The function uses the \code{\link[tidycensus]{get_acs}} function to obtain U.S. Census Bureau 5-year American Community Survey characteristics used for the geospatial computation. The yearly estimates are available for 2009 onward when ACS-5 data are available but are available from other U.S. Census Bureau surveys. The ACS-5 groups used in the computation of the five ICE metrics are:
\itemize{
\item \strong{B03002}: HISPANIC OR LATINO ORIGIN BY RACE
\item \strong{B15002}: SEX BY EDUCATIONAL ATTAINMENT FOR THE POPULATION 25 YEARS AND OVER
\item \strong{B19001}: HOUSEHOLD INCOME IN THE PAST 12 MONTHS (IN 20XX INFLATION-ADJUSTED DOLLARS)
\item \strong{B19001B}: HOUSEHOLD INCOME IN THE PAST 12 MONTHS (IN 20XX INFLATION-ADJUSTED DOLLARS) (BLACK OR AFRICAN AMERICAN ALONE HOUSEHOLDER)
\item \strong{B19001H}: HOUSEHOLD INCOME IN THE PAST 12 MONTHS (IN 20XX INFLATION-ADJUSTED DOLLARS) (WHITE ALONE, NOT HISPANIC OR LATINO HOUSEHOLDER)
}

Use the internal \code{state} and \code{county} arguments within the \code{\link[tidycensus]{get_acs}} function to specify geographic extent of the data output.

ICE metrics can range in value from -1 (most deprived) to 1 (most privileged). A value of 0 can thus represent two possibilities: (1) none of the residents are in the most privileged or most deprived categories, or (2) an equal number of persons are in the most privileged and most deprived categories, and in both cases indicates that the area is not dominated by extreme concentrations of either of the two groups.
}
\examples{
\dontrun{
# Wrapped in \dontrun{} because these examples require a Census API key.
  
  # Tract-level metric (2020)
  krieger(geo = "tract", state = "GA", year = 2020)
  
  # County-level metric (2020)
  krieger(geo = "county", state = "GA", year = 2020)
  
}

}
\seealso{
\code{\link[tidycensus]{get_acs}} for additional arguments for geographic extent selection (i.e., \code{state} and \code{county}).
}
