% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zipsByURI.R
\name{zipsByURI}
\alias{zipsByURI}
\title{Get files from NEON ECS Bucket using URLs in stacked data}
\usage{
zipsByURI(
  filepath,
  savepath = paste0(filepath, "/ECS_zipFiles"),
  pick.files = FALSE,
  check.size = TRUE,
  unzip = TRUE,
  saveZippedFiles = FALSE,
  token = NA_character_,
  progress = TRUE
)
}
\arguments{
\item{filepath}{The location of the NEON data containing URIs. Can be either a local directory containing NEON tabular data or a list object containing tabular data.}

\item{savepath}{The location to save the output files from the ECS bucket, optional. 
Defaults to creating a "ECS_zipFiles" folder in the filepath directory.}

\item{pick.files}{T or F, should the user be told the name of each file before downloading? 
Defaults to F. When working in batch mode, or other non-interactive workflow, use pick.files=F.}

\item{check.size}{T or F, should the user be told the total file size before downloading? 
Defaults to T. When working in batch mode, or other non-interactive workflow, use check.size=F.}

\item{unzip}{T or F, indicates if the downloaded zip files from ECS buckets should be 
unzipped into the same directory, defaults to T. Supports .zip and .tar.gz files currently.}

\item{saveZippedFiles}{T or F: should the zip files be retained after unzipping? Defaults to F.}

\item{token}{User specific API token (generated within data.neonscience.org user accounts). Optional.}

\item{progress}{T or F, should progress bars be printed? Defaults to TRUE.}
}
\value{
A folder in the working directory (or in savepath, if specified), containing all files meeting query criteria.
}
\description{
Read in a set of URLs from NEON data tables and then download the data from the NEON ECS buckets. 
Assumes data tables are in the format resulting from merging files using stackByTable().
File downloads from ECS can be extremely large; be prepared for long download times and large file storage.
}
\examples{
\dontrun{
# To download stream morphology data from stacked data:
zipsByURI(filepath="~/filesToStack00131/stackedFiles")
}
}
\references{
License: GNU AFFERO GENERAL PUBLIC LICENSE Version 3, 19 November 2007
}
\author{
Kaelin Cawley \email{kcawley@battelleecology.org}
}
