% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_class.R, R/neurovol.R
\docType{class}
\name{DenseNeuroVol-class}
\alias{DenseNeuroVol-class}
\alias{DenseNeuroVol}
\title{DenseNeuroVol Class}
\usage{
DenseNeuroVol(data, space, label = "", indices = NULL)
}
\arguments{
\item{data}{a three-dimensional \code{array}}

\item{space}{an instance of class \code{\linkS4class{NeuroSpace}}}

\item{label}{a \code{character} string}

\item{indices}{an optional 1-d index vector}
}
\value{
\code{\linkS4class{DenseNeuroVol}} instance
}
\description{
Represents a three-dimensional brain image backed by a dense array. This class
combines the spatial properties of \code{\linkS4class{NeuroVol}} with the data
storage capabilities of an array.

Construct a \code{\linkS4class{DenseNeuroVol}} instance
}
\details{
DenseNeuroVol objects are used for 3D brain images where most or all voxels contain
meaningful data. They provide efficient access to individual voxel values and are
suitable for operations that require frequent random access to voxel data.
}
\examples{
# Create a simple 3D brain volume
vol_data <- array(rnorm(64*64*64), c(64, 64, 64))
vol_space <- NeuroSpace(dim=c(64L, 64L, 64L), origin=c(0, 0, 0), spacing=c(1, 1, 1))
brain_vol <- new("DenseNeuroVol", .Data=vol_data, space=vol_space)

}
\seealso{
\code{\link{NeuroVol-class}}, \code{\link{SparseNeuroVol-class}}
}
