% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clean.R
\name{normalize_coordinates}
\alias{normalize_coordinates}
\title{Normalize the x and y coordinates for all the events (plays) in a
play-by-play}
\usage{
normalize_coordinates(play_by_play)
}
\arguments{
\item{play_by_play}{data.frame of play-by-play(s); see \code{\link[=gc_play_by_play]{gc_play_by_play()}}
and/or \code{\link[=wsc_play_by_play]{wsc_play_by_play()}} for reference; must be untouched by
non-nhlscraper functions; saves time if \code{\link[=flag_is_home]{flag_is_home()}} has already been
called}
}
\value{
data.frame with one row per event (play) and added columns
\code{xCoordNorm} and \code{yCoordNorm}
}
\description{
\code{normalize_coordinates()} normalizes the x and y coordinates for all the
events (plays) in a play-by-play such that they all attack towards +x.
}
\examples{
# May take >5s, so skip.
\donttest{
  test                   <- gc_play_by_play()
  test_is_home_flagged   <- flag_is_home(test)
  test_coords_normalized <- normalize_coordinates(test_is_home_flagged)
}
}
