% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clean.R
\name{strip_time_period}
\alias{strip_time_period}
\title{Strip the timestamp and period number into the time elapsed in the period
and game for all the events (plays) in a play-by-play}
\usage{
strip_time_period(play_by_play)
}
\arguments{
\item{play_by_play}{data.frame of play-by-play(s); see \code{\link[=gc_play_by_play]{gc_play_by_play()}}
and/or \code{\link[=wsc_play_by_play]{wsc_play_by_play()}} for reference; must be untouched by
non-nhlscraper functions; saves time if \code{\link[=strip_game_id]{strip_game_id()}} has already been
called}
}
\value{
data.frame with one row per event (play) and added columns
\code{secondsElapsedInPeriod} and \code{secondsElapsedInGame}
}
\description{
\code{strip_time_period()} strip the timestamp and period number into the time
elapsed in the period and game for all the events (plays) in a play-by-play.
}
\examples{
# May take >5s, so skip.
\donttest{
  test                      <- gc_play_by_play()
  test_game_id_stripped     <- strip_game_id(test)
  test_time_period_stripped <- strip_time_period(test_game_id_stripped)
}
}
