% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertDate.R
\name{convertDate}
\alias{convertDate}
\title{Converts date columns formatted as characters to be of type datetime}
\usage{
convertDate(ped, timeOrigin = as.Date("1970-01-01"), reportErrors = FALSE)
}
\arguments{
\item{ped}{a dataframe of pedigree information that may contain birth,
death, departure, or exit dates. The fields are optional, but will be used
if present.(optional fields: birth, death, departure, and exit).}

\item{timeOrigin}{date object used by \code{as.Date} to set \code{origin}.}

\item{reportErrors}{logical value if TRUE will scan the entire file and
make a list of all errors found. The errors will be returned in a
list of list where each sublist is a type of error found.}
}
\value{
A dataframe with an updated table with date columns converted from
\code{character} data type to \code{Date} data type. Values that do not
conform to the format \%Y\%m\%d are set to NA. NA values are left as NA.
}
\description{
Part of Pedigree Curation
}
\examples{
library(lubridate)
set_seed(10)
someBirthDates <- paste0(
  sample(seq(0, 15, by = 3), 10,
    replace = TRUE
  ) + 2000, "-",
  sample(1:12, 10, replace = TRUE), "-",
  sample(1:28, 10, replace = TRUE)
)
someBadBirthDates <- paste0(
  sample(1:12, 10, replace = TRUE), "-",
  sample(1:28, 10, replace = TRUE), "-",
  sample(seq(0, 15, by = 3), 10,
    replace = TRUE
  ) + 2000
)
someDeathDates <- sample(someBirthDates, length(someBirthDates),
  replace = FALSE
)
someDepartureDates <- sample(someBirthDates, length(someBirthDates),
  replace = FALSE
)
ped1 <- data.frame(
  birth = someBadBirthDates, death = someDeathDates,
  departure = someDepartureDates
)
someDates <- ymd(someBirthDates)
ped2 <- data.frame(
  birth = someDates, death = someDeathDates,
  departure = someDepartureDates
)
ped3 <- data.frame(
  birth = someBirthDates, death = someDeathDates,
  departure = someDepartureDates
)
someNADeathDates <- someDeathDates
someNADeathDates[c(1, 3, 5)] <- ""
someNABirthDates <- someDates
someNABirthDates[c(2, 4, 6)] <- NA
ped4 <- data.frame(
  birth = someNABirthDates, death = someNADeathDates,
  departure = someDepartureDates
)

## convertDate identifies bad dates
result <- tryCatch(
  {
    convertDate(ped1)
  },
  warning = function(w) {
    print("Warning in date")
  },
  error = function(e) {
    print("Error in date")
  }
)

## convertDate with error flag returns error list and not an error
convertDate(ped1, reportErrors = TRUE)

## convertDate recognizes good dates
all(is.Date(convertDate(ped2)$birth))
all(is.Date(convertDate(ped3)$birth))

## convertDate handles NA and empty character string values correctly
convertDate(ped4)
}
