% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapIdsToObfuscated.R
\name{mapIdsToObfuscated}
\alias{mapIdsToObfuscated}
\title{Map IDs to Obfuscated IDs}
\usage{
mapIdsToObfuscated(ids, map)
}
\arguments{
\item{ids}{character vector with original IDs}

\item{map}{named character vector where the values are the obfuscated IDs
and the vector of names (\code{names(map)}) is the vector of original names.}
}
\value{
A dataframe or vector with original IDs replaced by their obfuscated
counterparts.
}
\description{
This is not robust as it fails if all IDs are found not within \code{map}.
}
\examples{
set_seed(1)
ped <- qcStudbook(nprcgenekeepr::pedSix)
obfuscated <- obfuscatePed(ped, map = TRUE)
someIds <- c("s1", "s2", "d1", "d1")
mapIdsToObfuscated(someIds, obfuscated$map)
}
