% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTranscriptIdsWithParticipant.R
\name{getTranscriptIdsWithParticipant}
\alias{getTranscriptIdsWithParticipant}
\title{Gets a list of IDs of transcripts that include the given participant}
\usage{
getTranscriptIdsWithParticipant(labbcat.url, id)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{id}{A participant ID}
}
\value{
A list of transcript IDs
}
\description{
Returns a list of IDs of transcripts (i.e. transcript names) that include
the given participant.
}
\examples{
\dontrun{
## List transcripts in which UC427_ViktoriaPapp_A_ENG speaks
transcripts <- getTranscriptIdsWithParticipant(labbcat.url, "UC427_ViktoriaPapp_A_ENG")
}

}
\seealso{
\link{getParticipantIds}
}
\keyword{graph}
\keyword{transcript}
