% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/mvnorm.R
\name{dmvnorm_cpp}
\alias{dmvnorm_cpp}
\alias{rmvnorm_cpp}
\alias{dmvnorm}
\alias{rmvnorm}
\title{Multivariate normal distribution}
\usage{
dmvnorm_cpp(x, mean, Sigma, log = FALSE)

rmvnorm_cpp(mean, Sigma, log = FALSE)

dmvnorm(x, mean, Sigma, log = FALSE)

rmvnorm(n = 1, mean, Sigma, log = FALSE)
}
\arguments{
\item{x}{[\code{numeric()}]\cr
A quantile vector of length \code{p}.}

\item{mean}{[\code{numeric()}]\cr
The mean vector of length \code{p}.

For \code{dmvnorm()} and \code{rmvnorm()}, it can also be of length \code{1} for
convenience, then \code{rep(mean, p)} is considered.}

\item{Sigma}{[\code{matrix()}]\cr
The covariance matrix of dimension \code{p}.

It can also be a zero matrix.

For \code{rmvnorm()}, arbitrary dimensions (i.e., full rows and corresponding
columns) of \code{Sigma} can be \code{0}.

For \code{dmvnorm()} and \code{rmvnorm()} and if \code{p = 1}, it can also be a single
\code{numeric} for convenience. Note that \code{Sigma} is this case is a variance,
which is a different format than in \code{stats::dnorm()} or \code{stats::rnorm},
which require a standard deviation.}

\item{log}{[\code{logical(1)}]\cr
For \code{dmvnorm()}: Return the logarithm of the density value?

For \code{rmvnorm()}: Draw from a log-normal distribution?}

\item{n}{[\code{integer(1)}]\cr
An \code{integer}, the number of requested samples.}
}
\value{
For \code{dmvnorm()}: The density value.

For \code{rmvnorm()}: If \code{n = 1} a \code{vector} of length \code{p} (note
that it is a column vector for \code{rmvnorm_cpp()}), else
a \code{matrix} of dimension \code{n} times \code{p} with samples as rows.
}
\description{
The function \code{dmvnorm()} computes the density of a multivariate normal
distribution.

The function \code{rmvnorm()} samples from a multivariate normal distribution.

The functions with suffix \verb{_cpp} perform no input checks, hence are faster.

The univariate normal distribution is available as the special case \code{p = 1}.
}
\examples{
x <- c(0, 0)
mean <- c(0, 0)
Sigma <- diag(2)

# compute density
dmvnorm(x = x, mean = mean, Sigma = Sigma)
dmvnorm(x = x, mean = mean, Sigma = Sigma, log = TRUE)

# sample
rmvnorm(n = 3, mean = mean, Sigma = Sigma)
rmvnorm(mean = mean, Sigma = Sigma, log = TRUE)
}
\seealso{
Other simulation helpers: 
\code{\link{Simulator}},
\code{\link{correlated_regressors}()},
\code{\link{ddirichlet_cpp}()},
\code{\link{dtnorm_cpp}()},
\code{\link{dwishart_cpp}()},
\code{\link{simulate_markov_chain}()}
}
\concept{simulation helpers}
\keyword{distribution}
