% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mockCdmFromTables.R
\name{mockCdmFromTables}
\alias{mockCdmFromTables}
\title{Generates a mock CDM (Common Data Model) object based on existing CDM structures and additional tables.}
\usage{
mockCdmFromTables(cdm = mockCdmReference(), tables = list(), seed = NULL)
}
\arguments{
\item{cdm}{A `cdm_reference` object, which serves as the base structure where all additional tables will be integrated.
This parameter should already be initialized and can contain pre-existing standard or cohort-specific OMOP tables.}

\item{tables}{A named list of data frames representing additional tables to be integrated into the CDM.
These tables can include both standard OMOP tables such as 'drug_exposure' or 'condition_occurrence',
as well as cohort-specific tables that are not part of the standard OMOP model but are necessary for specific analyses.
Each table should be named according to its intended table name in the CDM structure.}

\item{seed}{An optional integer that sets the seed for random number generation used in creating mock data entries.
Setting a seed ensures that the generated mock data are reproducible across different runs of the function.
If 'NULL', the seed is not set, leading to non-deterministic behavior in data generation.}
}
\value{
Returns the updated `cdm` object with all the new tables added and integrated, ensuring consistency
        across the observational periods and the person entries.
}
\description{
This function takes an existing CDM reference (which can be empty) and a list of additional named tables to create
a more complete mock CDM object. It ensures that all provided observations fit within their respective observation
periods and that all individual records are consistent with the entries in the person table. This is useful for
creating reliable and realistic healthcare data simulations for development and testing within the OMOP CDM framework.
}
\examples{
\donttest{
library(omock)
library(dplyr)

# Create a mock cohort table
cohort <- tibble(
  cohort_definition_id = c(1, 1, 2, 2, 1, 3, 3, 3, 1, 3),
  subject_id = c(1, 4, 2, 3, 5, 5, 4, 3, 3, 1),
  cohort_start_date = as.Date(c(
    "2020-04-01", "2021-06-01", "2022-05-22", "2010-01-01", "2019-08-01",
    "2019-04-07", "2021-01-01", "2008-02-02", "2009-09-09", "2021-01-01"
  )),
  cohort_end_date = cohort_start_date
)

# Generate a mock CDM from preexisting CDM structure and cohort table
cdm <- mockCdmFromTables(cdm = mockCdmReference(), tables = list(cohort = cohort))

# Access the newly integrated cohort table and the standard person table in the CDM
print(cdm$cohort)
print(cdm$person)
}
}
