% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group-sim.R
\name{group_term_enrichment}
\alias{group_term_enrichment}
\title{Identify enriched terms in subgroup}
\usage{
group_term_enrichment(
  ontology,
  term_sets,
  group,
  permutations = 1000L,
  min_terms = 2L,
  mc.cores = NULL
)
}
\arguments{
\item{ontology}{\code{ontology_index} object.}

\item{term_sets}{List of character vectors of ontological term IDs.}

\item{group}{Integer/logical/character vector specifying indices/positions/names of subgroup for which to calculate a group similarity p-value.}

\item{permutations}{Number of permutations to test against, or if \code{NULL}, perform no permutations and return the unadjusted p-values for the occurrence of each term.}

\item{min_terms}{Minimum number of times a term should occur within the given group to be eligible for inclusion in the results.}

\item{mc.cores}{If not null and greater than on, the number of cores use calculating permutations (passed to \code{mclapply}).}
}
\value{
\code{data.frame} containing columns: \code{term} (with the term ID); \code{name} (term readable name); \code{in_term} (number of sets in the given group of containing the term); \code{in_no_term} (number of sets in the given group not containing the term); \code{out_term} and \code{out_no_term} (equivalently for the sets not in the given group); \code{p} (the p-values calculated by permutation for seeing a term with such a strong association, measured using Fisher's exact test, in a group of term sets the size of the given group among \code{term_sets}). Rows ordered by significance (i.e. the \code{p} columns).
}
\description{
Create a table of terms ranked by their significance of occurrence in a set of term sets amongst an enclosing set, with p-values computed by permutation. Terms are subselected so that only the minimal set of non-redundant terms at each level of frequency within the group are retained.
}
\seealso{
\code{\link{sample_group_sim}} \code{\link{create_sim_index}}
}
