% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmapi_user_blocks.R
\name{osm_list_active_user_blocks}
\alias{osm_list_active_user_blocks}
\title{List active blocks}
\usage{
osm_list_active_user_blocks(format = c("R", "xml", "json"))
}
\arguments{
\item{format}{Format of the output. Can be \code{"R"} (default), \code{"xml"}, or \code{"json"}.}
}
\value{
If \code{format = "R"}, returns a data frame with one row per block. No rows, no blocks.
\subsection{\code{format = "xml"}}{

Returns a \link[xml2:oldclass]{xml2::xml_document} with the following format:

\if{html}{\out{<div class="sourceCode xml">}}\preformatted{<?xml version="1.0" encoding="UTF-8"?>
<osm version="0.6" generator="OpenStreetMap server" copyright="OpenStreetMap and contributors" attribution="http://www.openstreetmap.org/copyright" license="http://opendatacommons.org/licenses/odbl/1-0/">
  <user_block id="101" created_at="2025-02-22T02:11:55Z" updated_at="2025-02-22T02:11:55Z" ends_at="2025-02-22T03:11:55Z" needs_view="true">
    <user uid="5" user="fakemod1"/>
    <creator uid="115" user="fakemod2"/>
  </user_block>
  <user_block id="100" created_at="2025-02-22T02:11:10Z" updated_at="2025-02-22T02:11:10Z" ends_at="2025-02-22T02:11:10Z" needs_view="true">
    <user uid="5" user="fakemod1"/>
    <creator uid="115" user="fakemod2"/>
  </user_block>
  ...
</osm>
}\if{html}{\out{</div>}}

Empty \verb{<osm>} element indicates no active blocks.
}

\subsection{\code{format = "json"}}{

Returns a list with the following json structure:

\if{html}{\out{<div class="sourceCode json">}}\preformatted{\{
  "version":"0.6","generator":"OpenStreetMap server","copyright":"OpenStreetMap and contributors","attribution":"http://www.openstreetmap.org/copyright","license":"http://opendatacommons.org/licenses/odbl/1-0/",
  "user_blocks":[
    \{
      "id":101,
      "created_at":"2025-02-22T02:11:55Z",
      "updated_at":"2025-02-22T02:11:55Z",
      "ends_at":"2025-02-22T03:11:55Z",
      "needs_view":true,
      "user":\{"uid":5,"user":"fakemod1"\},
      "creator":\{"uid":115,"user":"fakemod2"\}
    \},
    \{
      "id":100,
      "created_at":"2025-02-22T02:11:10Z",
      "updated_at":"2025-02-22T02:11:10Z",
      "ends_at":"2025-02-22T02:11:10Z",
      "needs_view":true,
      "user":\{"uid":5,"user":"fakemod1"\},
      "creator":\{"uid":115,"user":"fakemod2"\}
    \},
    ...
  ]
\}
}\if{html}{\out{</div>}}
}
}
\description{
Allows to check if the currently authorized user is blocked.
}
\details{
This endpoint is accessible even with an active block, unlike some other endpoints requiring authorization.
}
\examples{
\dontrun{
osm_list_active_user_blocks()
}
}
\seealso{
Other user blocks' functions: 
\code{\link{osm_create_user_block}()},
\code{\link{osm_get_user_blocks}()}
}
\concept{user blocks' functions}
