% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meter-provider-noop.R
\name{otel_counter}
\alias{otel_counter}
\title{OpenTelemetry Counter Object}
\value{
Not applicable.
}
\description{
\link{otel_meter_provider} -> \link{otel_meter} -> \link{otel_counter},
\link{otel_up_down_counter}, \link{otel_histogram}, \link{otel_gauge}
}
\details{
Usually you do not need to deal with otel_counter objects directly.
\code{\link[=counter_add]{counter_add()}} automatically sets up a meter and creates a counter
instrument, as needed.

A counter object is created by calling the \code{create_counter()} method
of an \code{\link[=otel_meter_provider]{otel_meter_provider()}}.

You can use the \code{add()} method to increment the counter by a positive
amount.

In R counters are represented by double values.
}
\section{Methods}{
\subsection{\code{counter$add()}}{

Increment the counter by a fixed amount.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{counter$add(value, attributes = NULL, span_context = NULL, ...)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{value}: Value to increment the counter with.
\item \code{attributes}: Additional attributes to add.
\item \code{span_context}: Span context. If missing, the active context is used,
if any.
}
}

\subsection{Value}{

The counter object itself, invisibly.
}

}
}

\examples{
mp <- get_default_meter_provider()
mtr <- mp$get_meter()
ctr <- mtr$create_counter("session")
ctr$add(1)
}
\seealso{
Other low level metrics API: 
\code{\link{get_default_meter_provider}()},
\code{\link{get_meter}()},
\code{\link{meter_provider_noop}},
\code{\link{otel_gauge}},
\code{\link{otel_histogram}},
\code{\link{otel_meter}},
\code{\link{otel_meter_provider}},
\code{\link{otel_up_down_counter}}
}
\concept{low level metrics API}
