% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record.R
\name{with_otel_record}
\alias{with_otel_record}
\title{Record OpenTelemetry output, for testing purposes}
\usage{
with_otel_record(
  expr,
  what = c("traces", "metrics"),
  tracer_opts = list(),
  meter_opts = list()
)
}
\arguments{
\item{expr}{Expression to evaluate.}

\item{what}{Character vector, type(s) of OpenTelemetry output to collect.}

\item{tracer_opts}{Named list of options to pass to the tracer provider.}

\item{meter_opts}{Named list of options to pass to the meter provider.}
}
\value{
A list with the output for each output type. Entries:
\itemize{
\item \code{value}: value of \code{expr}.
\item \code{traces}: the recorded spans, if requested in \code{what}.
\item \code{metrics}: the recorded metrics measurements, if requested in \code{what}.
}
}
\description{
You can use this function to test that OpenTelemetry output is
correctly generated for your package or application.
}
\details{
It evaluates the supplied expression, collects OpenTelemetry output
from it and returns it.

Note: \code{with_otel_record()} cannot record logs yet.

\code{with_otel_record()} uses \link{tracer_provider_memory} and
\link{meter_provider_memory} internally.
}
\examples{
spns <- with_otel_record({
  trc <- otel::get_tracer("mytracer")
  spn1 <- trc$start_local_active_span()
  spn2 <- trc$start_local_active_span("my")
  spn2$end()
  spn1$end()
  NULL
})
spns
}
