% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ox.R
\name{ox}
\alias{ox}
\alias{xo}
\title{Short hand if-else}
\usage{
ox(.f, ..., .then = list(...)[[1]], .else = rev(list(...))[[1]])

xo(.f, ..., .then = list(...)[[1]], .else = rev(list(...))[[1]])
}
\arguments{
\item{.f}{(\code{function})\cr
to be applied on  \code{...}. Must return single logical value.}

\item{...}{arguments passed to the \code{.f}.}

\item{.then}{A positive-replacement. NOTE, that if \code{.then} is not specified
directly by named argument then the first argument from \code{...} will
be taken.}

\item{.else}{A negative-replacement. NOTE, that if \code{.else} is not specified
directly by named argument then the last argument from \code{...} will
be considered as a replacement.}
}
\value{
object identical to \code{.then} or \code{.else} depending on the condition
result.
}
\description{
Short hand if-else functions for simple values switching.
}
\details{
\if{html}{\figure{uml1.jpg}{options: width="75\%" alt="Figure: uml1.jpg"}}
\if{latex}{\figure{uml1.jpg}{options: width=7cm}}

\code{ox} evaluates function \code{.f} which returns a single logical value and
depending on the result \code{ox} returns:
\itemize{
\item on \code{TRUE} returns \code{.then}.
\item on \code{FALSE} returns \code{.else}.
}

It's important to note is that \code{.then} and \code{.else} have a default values set
as the first and the last element of the \code{...}. This means that they don't
have to be specified if both are arguments of \code{.f}.\cr
If any of them are not arguments of \code{.f} then this argument should be
specified directly as \code{.then} or \code{.else}, otherwise it will be passed to the
function.\cr\cr
As, far as \code{.then} and \code{.else} won't be specified order of arguments in \code{...}
matters for \code{ox} but it's up to you if they are passed in the correct order
to the \code{.f}. Then one, might consider name the argument so \code{.f} will be
executed as expected. Consider following example\preformatted{greater_than_by <- function(x, y, by) x > (y + by)
ox(greater_than_by, x = 5, by = 3, y = 3)
}

In above, one needs to move \code{y} to the end so that it will be considered as
\code{.else}.

To invert the switch one can use \code{xo} which is equivalent of
\code{ox(Negate(.f), ..., .then, .else)}.
}
\examples{
# if (is.null(NULL)) NULL else 1
ox(NULL, .f = is.null, .else = 1)

# if (is("text", "character")) "text" else "not a character"
ox("text", .f = is, "character", .else = "not a character")

# if (1 > 2) 1 else 2
ox(`>`, 1, 2)
# if (!is.null(NULL)) NULL else 1
xo(NULL, .f = is.null, .else = 1)

# if (!is("text", "character")) "text" else "not a character"
xo("text", .f = is, "character", .else = "not a character")

# if (!1 > 2) 1 else 2
xo(`>`, 1, 2)
}
