% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/criticalVector.R
\name{criticalVector}
\alias{criticalVector}
\title{Critical vector}
\usage{
criticalVector(pvalues, family = "simes", alpha = 0.05, lambda, delta = 1, m = NULL)
}
\arguments{
\item{pvalues}{Matrix of pvalues with dimensions \eqn{m \times B} used instead of the data matrix \code{X}. Default to \code{NULL}.}

\item{family}{String character. Name of the family confidence envelope to compute the critical vector 
from \code{"simes"}, \code{"aorc"}, \code{"beta"}, \code{"higher.criticism"}, and \code{"power"}.
Default to "simes".}

\item{alpha}{Numeric value in `[0,1]`. \eqn{\alpha} level to control the family-wise error rate. Default to 0.05.}

\item{lambda}{Numeric value. \eqn{\lambda} value computed by \code{\link{lambdaOpt}}.
Default to 1.}

\item{delta}{Numeric value. \eqn{\delta} value. Please see the reference below. Default to 1.}

\item{m}{Numeric value. Number of hypothesis. Default to \code{NULL}.}
}
\value{
Numeric vector. Critical vector curve with length \eqn{m}.
}
\description{
Compute critical vector curve.
}
\examples{
db <- simulateData(pi0 = 0.8, m = 100, n = 20, rho = 0)
out <- pARI::signTest(X = db)
pv <- cbind(out$pv, out$pv_H0)
cv <- criticalVector(pvalues = pv, family = "simes", lambda = 1)
plot(sort(pv[,1]), type = "l")
lines(cv)
}
\references{
Andreella, A., Hemerik, J., Finos, L., Weeda, W., & Goeman, J. (2023). Permutation-based true discovery proportions for functional magnetic resonance imaging cluster analysis. Statistics in Medicine, 42(14), 2311-2340.
}
\seealso{
\code{\link{lambdaOpt}}
}
\author{
Angela Andreella
}
