% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/andersentest.pers.R
\name{andersentest.pers}
\alias{andersentest.pers}
\title{Andersen's Likelihood Ratio Test for Object of class "pers"}
\usage{
andersentest.pers(
  pers_obj,
  split = "median",
  splitseed = "no",
  pot = NULL,
  zerocor = NULL
)
}
\arguments{
\item{pers_obj}{an object of class\code{"pers"} - see function \code{\link{pers}}.}

\item{split}{Specifies the splitting criterion. Basically there are three different options available - each with several modes - which are controlled by passing the corresponding character expression to the argument. 

1) Using the rawscore for splitting into subsamples with the following modes: \code{split = "median"} median raw score split - high score group and low score group; \code{split = "mean"} mean raw score split - high score group and low score group.
Finaly \code{split = "score"} that is splitting \code{daten} into as many subsamples as there are raw score groups - discarding min and max (theoretical) score group - which matches the concept proposed by Andersen (1973).

2) Dividing the persons in \code{daten} into subsamples with equal size by random allocation with the following modes: \code{split = "random"} (which is equivalent to \code{split = "random.2"}) divides persons into two subsamples with equal size. In general the number of desired subsamples must be expressed after the dot in the character expression - e.g. \code{split = "random.6"} divides persons into 6 subsamples (with equal size) by random allocation etc. 

3) The third option is using a manifest variable as a splitting criterion. In this case a vector with the same length as number of cases in \code{daten} must be passed to the argument grouping the data into subsamples. This vector should be coded as \code{"factor"} or a \code{"numeric"} integer vector with min = 1.}

\item{splitseed}{numeric, used for \code{set.seed(splitseed)} for random splitting - see argument \code{split}.}

\item{pot}{optional argument, at default (\code{pot=NULL}) setting is read from \code{pers_obj} - see description for \code{\link{pair}}.}

\item{zerocor}{optional argument, at default (\code{zerocor=NULL}) setting is read from \code{pers_obj} - see description for \code{\link{pair}}.

pot=pers_obj$pair$fuargs$pot, zerocor=pers_obj$pair$fuargs$zerocor}
}
\value{
A (list) object of class \code{"andersentest.pers"} ...
}
\description{
The Andersen likelihood ratio test is based on splitting the dataset into subgroups of persons. One can argue that it is a significance testable version of the more descriptive graphical model check - see \code{\link{grm}}.
}
\details{
Andersen (1973) proposed to split the dataset by [raw] score groups, which can be achieved setting the argument \code{split = "score"}. However as pointed out by Rost (2004) there might be several different splitting criteria for testing subsample invariance of the raschmodel. Thus the argument \code{split} provides some other options for splitting the data - see description of arguments.
}
\examples{
\dontrun{
data(bfiN) # loading example data set
data(bfi_cov) # loading covariates to bfiN data set
model <- pers(pair(bfiN,m=6))
andersentest.pers(model, split = bfi_cov$gender)
andersentest.pers(model, split = "random")
andersentest.pers(model, split = "median")
### unsing simulated data:
data("sim200x3")
model2 <- pers(pair(sim200x3))
andersentest.pers(model2, split = "median")
}
}
\references{
Andersen, E. B. (1973). A goodness of fit test for the rasch model. \emph{Psychometrika, 38}(1), 123–140.

Rost, J. (2004). \emph{Lehrbuch Testtheorie - Testkonstruktion} (2 nd Ed.) Huber: Bern.
}
