% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrim_linear_mda.R
\name{details_discrim_linear_mda}
\alias{details_discrim_linear_mda}
\title{Linear discriminant analysis via flexible discriminant analysis}
\description{
\code{\link[mda:fda]{mda::fda()}} (in conjunction with \code{\link[mda:gen.ridge]{mda::gen.ridge()}} can fit a linear
discriminant analysis model that penalizes the predictor coefficients with a
quadratic penalty (i.e., a ridge or weight decay approach).
}
\details{
For this engine, there is a single mode: classification
\subsection{Tuning Parameters}{

This model has 1 tuning parameter:
\itemize{
\item \code{penalty}: Amount of Regularization (type: double, default: 1.0)
}
}

\subsection{Translation from parsnip to the original package}{

The \strong{discrim} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(discrim)

discrim_linear(penalty = numeric(0)) |> 
  set_engine("mda") |> 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Linear Discriminant Model Specification (classification)
## 
## Main Arguments:
##   penalty = numeric(0)
## 
## Computational engine: mda 
## 
## Model fit template:
## mda::fda(formula = missing_arg(), data = missing_arg(), weights = missing_arg(), 
##     lambda = numeric(0), method = mda::gen.ridge, keep.fitted = FALSE)
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip will
convert factor columns to indicators.

Variance calculations are used in these computations so \emph{zero-variance}
predictors (i.e., with a single unique value) should be eliminated
before fitting the model.
}

\subsection{Case weights}{

This model can utilize case weights during model fitting. To use them,
see the documentation in \link{case_weights} and the examples
on \code{tidymodels.org}.

The \code{fit()} and \code{fit_xy()} arguments have arguments called
\code{case_weights} that expect vectors of case weights.
}

\subsection{References}{
\itemize{
\item Hastie, Tibshirani & Buja (1994) Flexible Discriminant Analysis by
Optimal Scoring, \emph{Journal of the American Statistical Association},
89:428, 1255-1270
}
}
}
\keyword{internal}
