% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swarm.R
\name{ParticleSwarm}
\alias{ParticleSwarm}
\title{Swarm}
\description{
Particle Swarm, used to launch the Particle Swarm Optimisation, The PSO is used to maximise the fitness.
}
\examples{
# In this example we use the PSO to solve the following equation:
# a * 5 + b * 25 + 10 = 15

fitness_function <- function(values){
  a <- values[1]
  b <- values[2]
  particule_result <- a*5 + b*25 + 10
  difference <- 15 - particule_result
  fitness <- 1 - abs(difference)
  return(fitness)
}

values_ranges <- list(c(-10^3,10^3),c(-10^3,10^3))

swarm <- ParticleSwarm$new(pop_size = 200,
                           values_names = list("a","b"),
                           fitness_function = fitness_function,
                           max_it = 75,
                           acceleration_coefficient_range = list(c(0,1),c(0,1)),
                           inertia = 0.5,
                           ranges_of_values = values_ranges)
swarm$run(plot = FALSE,verbose = FALSE,save_file = FALSE)
# the solution is :
swarm$swarm_best_values
swarm$swarm_best_values[[1]]*5 + swarm$swarm_best_values[[2]] *25 + 10

## ------------------------------------------------
## Method `ParticleSwarm$new`
## ------------------------------------------------

# Create a ParticleSwarm object
swarm <- ParticleSwarm$new(pop_size=20,
                            values_names=c('a','b'),
                            max_it=20,
                            fitness_function = function(values){return(values[1]+values[2])},
                            acceleration_coefficient=list(c(0.5,1),c(0.5,1)),
                            inertia=0.5,
                            ranges_of_values=list(c(-100,100),c(-100,100)))

## ------------------------------------------------
## Method `ParticleSwarm$run`
## ------------------------------------------------

# Create a ParticleSwarm object
swarm <- ParticleSwarm$new(pop_size=20,
                            values_names=c('a','b'),
                            max_it=20,
                            fitness_function = function(values){return(values[1]+values[2])},
                            acceleration_coefficient=list(c(0.5,1),c(0.5,1)),
                            inertia=0.5,
                            ranges_of_values=list(c(-100,100),c(-100,100)))
# run the PSO
swarm$run(verbose = FALSE,
          plot = FALSE,
          save_file = FALSE)
# return the best result:
print(swarm$swarm_best_values)
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{pop_size}}{(numeric) number of particles in the swarm}

\item{\code{ranges_of_values}}{(list) range for each value for the particle}

\item{\code{values_names}}{(list) list of names for each value (optionnal)}

\item{\code{pop}}{(list) list of particle in the swarm}

\item{\code{fitness_function}}{(function) fitness function used to find the fitness of the particle}

\item{\code{list_fitness}}{(list) list of fitness of the particles}

\item{\code{max_it}}{(numeric) maximum number of iteration}

\item{\code{acceleration_coefficient_range}}{(list) coefficient c1 and c2 for the particles}

\item{\code{swarm_best_fitness}}{(numeric) best fitness of the swarm}

\item{\code{swarm_best_values}}{(numeric) values of the particle with the best fitness}

\item{\code{inertia}}{(numeric) inertia of the particles}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ParticleSwarm$new()}}
\item \href{#method-run}{\code{ParticleSwarm$run()}}
\item \href{#method-generate_pop}{\code{ParticleSwarm$generate_pop()}}
\item \href{#method-move_the_swarm}{\code{ParticleSwarm$move_the_swarm()}}
\item \href{#method-save_pop}{\code{ParticleSwarm$save_pop()}}
\item \href{#method-plot_the_swarm_2D}{\code{ParticleSwarm$plot_the_swarm_2D()}}
\item \href{#method-plot_the_swarm_3D}{\code{ParticleSwarm$plot_the_swarm_3D()}}
\item \href{#method-print}{\code{ParticleSwarm$print()}}
\item \href{#method-clone}{\code{ParticleSwarm$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new ParticleSwarm object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParticleSwarm$new(
  pop_size,
  values_names,
  fitness_function,
  max_it,
  acceleration_coefficient_range,
  inertia,
  ranges_of_values
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pop_size}}{number of individu in the swarm. (numeric)}

\item{\code{values_names}}{list of names for each value (character)}

\item{\code{fitness_function}}{function used to test the Particle and find his fitness. (function)}

\item{\code{max_it}}{Maximum number of iteration for the PSO. (numeric)}

\item{\code{acceleration_coefficient_range}}{a vector of four values (min and max for c1 and c2) (numeric)}

\item{\code{inertia}}{The inertia for the particle (the influence of the previous velocity on the next velocity). (numeric)}

\item{\code{ranges_of_values}}{range for each value of the particle (min and max). (List)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{ParticleSwarm} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a ParticleSwarm object
swarm <- ParticleSwarm$new(pop_size=20,
                            values_names=c('a','b'),
                            max_it=20,
                            fitness_function = function(values){return(values[1]+values[2])},
                            acceleration_coefficient=list(c(0.5,1),c(0.5,1)),
                            inertia=0.5,
                            ranges_of_values=list(c(-100,100),c(-100,100)))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-run"></a>}}
\if{latex}{\out{\hypertarget{method-run}{}}}
\subsection{Method \code{run()}}{
Make the Particle Swarm Optimisation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParticleSwarm$run(
  verbose = TRUE,
  plot = TRUE,
  save_file = FALSE,
  dir_name = "PSO_pop"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbose}}{print the different step (iteration and individu)}

\item{\code{plot}}{plot the result of each iteration (only for 2D or 3D problem)}

\item{\code{save_file}}{save the population of each Iteration in a file and save the plot if plot=TRUE}

\item{\code{dir_name}}{name of the directory, default value is PSO_pop}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a ParticleSwarm object
swarm <- ParticleSwarm$new(pop_size=20,
                            values_names=c('a','b'),
                            max_it=20,
                            fitness_function = function(values){return(values[1]+values[2])},
                            acceleration_coefficient=list(c(0.5,1),c(0.5,1)),
                            inertia=0.5,
                            ranges_of_values=list(c(-100,100),c(-100,100)))
# run the PSO
swarm$run(verbose = FALSE,
          plot = FALSE,
          save_file = FALSE)
# return the best result:
print(swarm$swarm_best_values)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-generate_pop"></a>}}
\if{latex}{\out{\hypertarget{method-generate_pop}{}}}
\subsection{Method \code{generate_pop()}}{
create the population of the swarm (this method is automatically called by the run method)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParticleSwarm$generate_pop(verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbose}}{print the advancement or not}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-move_the_swarm"></a>}}
\if{latex}{\out{\hypertarget{method-move_the_swarm}{}}}
\subsection{Method \code{move_the_swarm()}}{
The method used to change the location of each particle (this method is automatically called by the run method)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParticleSwarm$move_the_swarm(verbose)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbose}}{print or not the advancement}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-save_pop"></a>}}
\if{latex}{\out{\hypertarget{method-save_pop}{}}}
\subsection{Method \code{save_pop()}}{
The method used to save the values and fitness of the population in a CSV file (this method is automatically called by the run method if you have chosen to save the result)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParticleSwarm$save_pop(nb_it, dir_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nb_it}}{number of the iteration, used to create the name of the csv file}

\item{\code{dir_name}}{Name of the directory}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_the_swarm_2D"></a>}}
\if{latex}{\out{\hypertarget{method-plot_the_swarm_2D}{}}}
\subsection{Method \code{plot_the_swarm_2D()}}{
method used to plot a 2D plot (this method is automatically called by the run method if you have chosen to plot the swarm)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParticleSwarm$plot_the_swarm_2D(nb_it, save_file)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nb_it}}{number of the iteration used to save the plot as a png}

\item{\code{save_file}}{save the plot as a file}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_the_swarm_3D"></a>}}
\if{latex}{\out{\hypertarget{method-plot_the_swarm_3D}{}}}
\subsection{Method \code{plot_the_swarm_3D()}}{
method used to plot a 3D plot
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParticleSwarm$plot_the_swarm_3D(nb_it, save_file)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nb_it}}{number of the iteration used to save the plot as a png (this method is automatically called by the run method if you have chosen to plot the swarm)}

\item{\code{save_file}}{save the plot as a file}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print the current result of the population
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParticleSwarm$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParticleSwarm$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
