% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pm_ecoregions.R
\name{pm_by_ecoregion}
\alias{pm_by_ecoregion}
\title{List species by ecoregion}
\usage{
pm_by_ecoregion(
  ecoregion,
  order = NULL,
  family = NULL,
  genus = NULL,
  endemic = NULL
)
}
\arguments{
\item{ecoregion}{Character vector with one or more ecoregion codes
(e.g. \code{"YUN"}, \code{"SB"}, \code{"COS"}). At least one code
must be provided. Invalid codes will generate a warning.}

\item{order}{Optional character vector with one or more taxonomic orders
to keep. If \code{NULL} (default), no filter is applied by order.}

\item{family}{Optional character vector with one or more families to keep.
If \code{NULL} (default), no filter is applied by family.}

\item{genus}{Optional character vector with one or more genera to keep.
If \code{NULL} (default), no filter is applied by genus.}

\item{endemic}{Optional logical. If \code{TRUE}, only endemic species
are returned; if \code{FALSE}, only non-endemic species are returned;
if \code{NULL} (default), no filter is applied by endemism.}
}
\value{
A tibble with a subset of rows from \code{peru_mammals}
corresponding to species present in at least one of the requested
ecoregions. Returns an empty tibble if no species match the criteria.
}
\description{
Convenience wrapper to list species occurring in one or more Peruvian
ecoregions. This function uses \code{\link{pm_species}()} internally and
therefore supports the same taxonomic and endemism filters.
}
\examples{
# All species in Yungas
pm_by_ecoregion("YUN")

# Endemic species in Selva Baja (SB)
pm_by_ecoregion("SB", endemic = TRUE)

# Rodents in Costa and Vertiente Occidental
pm_by_ecoregion(c("COS", "VOC"), order = "Rodentia")

# Bats in multiple ecoregions
pm_by_ecoregion(c("YUN", "SB"), order = "Chiroptera")
pm_by_ecoregion(c("YUN", "SB"), order = "Chiroptera",
endemic =  TRUE)

}
\seealso{
\code{\link{pm_list_ecoregions}()} to see available ecoregion codes,
\code{\link{pm_species}()} for the underlying function.
}
