% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gJSD.R
\name{gJSD}
\alias{gJSD}
\title{Generalized Jensen-Shannon Divergence}
\usage{
gJSD(x, unit = "log2", weights = NULL, est.prob = NULL)
}
\arguments{
\item{x}{a probability matrix.}

\item{unit}{a character string specifying the logarithm unit that shall be used to compute distances that depend on log computations.}

\item{weights}{a numeric vector specifying the weights for each distribution in \code{x}.
Default: \code{weights} = \code{NULL}; in this case all distributions are weighted equally (= uniform distribution of weights).
In case users wish to specify non-uniform weights for e.g. 3 distributions, they
can specify the argument \code{weights = c(0.5, 0.25, 0.25)}. This notation
denotes that \code{vec1} is weighted by \code{0.5}, \code{vec2} is weighted by \code{0.25}, and \code{vec3} is weighted by \code{0.25} as well.}

\item{est.prob}{method to estimate probabilities from input count vectors such as non-probability vectors. Default: \code{est.prob = NULL}. Options are:
\itemize{
\item \code{est.prob = "empirical"}: The relative frequencies of each vector are computed internally. For example an input matrix \code{rbind(1:10, 11:20)} will be transformed to a probability vector \code{rbind(1:10 / sum(1:10), 11:20 / sum(11:20))}
}}
}
\value{
The Jensen-Shannon divergence between all possible combinations of comparisons.
}
\description{
This function computes the Generalized Jensen-Shannon Divergence of a probability matrix.
}
\details{
Function to compute the Generalized Jensen-Shannon Divergence

\eqn{JSD_{\pi_1,...,\pi_n}(P_1, ..., P_n) = H(\sum_{i = 1}^n \pi_i * P_i) - \sum_{i = 1}^n \pi_i*H(P_i)}

where \eqn{\pi_1,...,\pi_n} denote the weights selected for the probability vectors \code{P_1,...,P_n} and \code{H(P_i)} denotes the Shannon Entropy of probability vector \code{P_i}.
}
\examples{
# define input probability matrix
Prob <- rbind(1:10/sum(1:10), 20:29/sum(20:29), 30:39/sum(30:39))

# compute the Generalized JSD comparing the PS probability matrix
gJSD(Prob)

# Generalized Jensen-Shannon Divergence between three vectors using different log bases
gJSD(Prob, unit = "log2") # Default
gJSD(Prob, unit = "log")
gJSD(Prob, unit = "log10")

# Jensen-Shannon Divergence Divergence between count vectors P.count and Q.count
P.count <- 1:10
Q.count <- 20:29
R.count <- 30:39
x.count <- rbind(P.count, Q.count, R.count)
gJSD(x.count, est.prob = "empirical")

}
\seealso{
\code{\link{KL}}, \code{\link{H}}, \code{\link{JSD}},
 \code{\link{CE}}, \code{\link{JE}}
}
\author{
Hajk-Georg Drost
}
