% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway_search.R
\name{pathway_search}
\alias{pathway_search}
\title{Query KEGG pathways for a given set of metabolites}
\usage{
pathway_search(metab, organism, min_size = 2)
}
\arguments{
\item{metab}{vector of metabolite KEGG codes}

\item{organism}{organism code in KEGG database}

\item{min_size}{minimal number of metabolites required for a pathway to be
returned}
}
\value{
a data.frame with metabolites in rows and the following information
in columns: \itemize{
 \item \code{metabolite_code} metabolite code
 \item \code{metabolite_name} metabolite name
 \item \code{pathway_code} pathway code (identifier)
 \item \code{pathway_name} name of the pathway
}
}
\description{
Query KEGG pathways for a given set of metabolites
}
\examples{
if (requireNamespace("KEGGREST", quietly = TRUE)) {
  data("MTBLS422")
  quantif <- from_ASICS_to_PHOENICS(quantif)
  \donttest{
  pathways <- pathway_search(metab = colnames(quantif), organism = "mmu")
  }
}

}
\references{
Kanehisa M., Goto S. (2000). KEGG: Kyoto Encyclopedia of Genes and Genomes,
\emph{Nucleic Acids Research}, Volume 28, Issue 1, Pages 27--30,
\doi{10.1093/nar/28.1.27}

Tenenbaum D., Maintainer B. (2022). KEGGREST: Client-side REST access to the
Kyoto Encyclopedia of Genes and Genomes (KEGG). R package version 1.38.0.
}
\author{
Camille Guilmineau <camille.guilmineau@inrae.fr>\cr
Remi Servien <remi.servien@inrae.fr>\cr
Nathalie Vialaneix <nathalie.vialaneix@inrae.fr>
}
