% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/water.et.r
\name{net_irradiance}
\alias{net_irradiance}
\title{Net radiation flux}
\usage{
net_irradiance(
  temperature,
  sw.down.irradiance,
  lw.down.irradiance = NULL,
  sw.albedo = 0.23,
  lw.emissivity = 0.98,
  water.vp = 0,
  R_rel = 1
)
}
\arguments{
\item{temperature}{numeric vector of air temperatures (C) at 2 m height.}

\item{sw.down.irradiance, lw.down.irradiance}{numeric Down-welling short wave
and long wave radiation radiation (W/m2).}

\item{sw.albedo}{numeric Albedo as a fraction of one (/1).}

\item{lw.emissivity}{numeric Emissivity of the surface (ground or vegetation)
for long wave radiation.}

\item{water.vp}{numeric vector of water vapour pressure in air (Pa), ignored
if \code{lw.down.irradiance} is available.}

\item{R_rel}{numeric The ratio of actual and clear sky short wave irradiance
(/1).}
}
\value{
A numeric vector of evapotranspiration estimates expressed as
  W / m-2.
}
\description{
Estimate net radiation balance expressed as a flux in W/m2. If
\code{lw.down.irradiance} is passed a value in W / m2 the difference is
computed directly and if not an approximate value is estimated, using
\code{R_rel = 0.75} which corresponds to clear sky, i.e., uncorrected for
cloudiness. This is the approach to estimation that is recommended by FAO for
hourly estimates while here we use it for instantaneous or mean flux rates.
}
\seealso{
Other Evapotranspiration and energy balance related functions.: 
\code{\link{ET_ref}()}
}
\concept{Evapotranspiration and energy balance related functions.}
