% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mosaic.R
\name{mosaic_chm_extract}
\alias{mosaic_chm_extract}
\title{Extract Canopy Height and Volume}
\usage{
mosaic_chm_extract(chm, shapefile)
}
\arguments{
\item{chm}{A list object containing the Canopy Height Model (CHM) generated
by the \code{\link[=mosaic_chm]{mosaic_chm()}} function.}

\item{shapefile}{An \code{sf} object representing the plot boundaries for which
the metrics will be extracted.}
}
\value{
A \code{sf} object with extracted metrics including minimum, 10th
percentile, median (50th percentile), 90th percentile, interquartile range
(IQR), mean, maximum canopy height, coefficient of variation (CV) of canopy
height, canopy height entropy, total volume, covered area, plot area, and
coverage percentage. Centroid coordinates (x, y) of each plot are also
included.
}
\description{
This function extracts canopy height and volume metrics for given plots
within a specified shapefile.
}
\details{
The function uses the \code{exactextractr} package to extract canopy height and
volume metrics from the CHM. For each plot in the shapefile, the function
computes various statistics on the canopy height values (e.g., min, max,
percentiles, mean, CV, entropy) and sums the volume values. If a mask was
applied in the CHM calculation, the covered area and plot area are also
computed.
}
