% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_shp.R
\name{plot.image_shp}
\alias{plot.image_shp}
\title{S3 method \code{plot} for \code{image_shp} objects}
\usage{
\method{plot}{image_shp}(
  x,
  img = NULL,
  col_line = "black",
  size_line = 2,
  col_text = "black",
  size_text = 0.75,
  ...
)
}
\arguments{
\item{x}{An object computed with \code{\link[=image_shp]{image_shp()}}.}

\item{img}{The image that was used to compute the shapefile (optional)}

\item{col_line, col_text}{The color of the line/text in the grid. Defaults to
\code{"red"}.}

\item{size_line, size_text}{The size of the line/text in the grid. Defaults to
\code{2.5}.}

\item{...}{Currently not used.}
}
\value{
A \code{NULL} object
}
\description{
Draws the bounding boxes for each object computed with \code{\link[=image_shp]{image_shp()}}.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
flax <- image_pliman("flax_leaves.jpg")
shape <- image_shp(flax, nrow = 3, ncol = 5)

# grid on the existing image
plot(flax)
plot(shape)
}
}
