% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_shapefile.R
\name{shapefile_surface}
\alias{shapefile_surface}
\title{Generate a spatial surface plot based on interpolated values}
\usage{
shapefile_surface(
  model,
  curve = TRUE,
  nx = 300,
  ny = 300,
  xlab = "Longitude (UTM)",
  ylab = "Latitude (UTM)",
  col = custom_palette(c("darkred", "yellow", "forestgreen"), n = 100),
  ...
)
}
\arguments{
\item{model}{An interpolated spatial object (e.g., from \code{shapefile_interpolate()}) containing the data for plotting.}

\item{curve}{Logical; if TRUE, a contour plot is generated (\code{type = "C"}), otherwise an image plot (\code{type = "I"}). Default is TRUE.}

\item{nx}{Integer; the number of grid cells in the x-direction. Default is 300.}

\item{ny}{Integer; the number of grid cells in the y-direction. Default is 300.}

\item{xlab}{Character; label for the x-axis. Default is "Longitude (UTM)".}

\item{ylab}{Character; label for the y-axis. Default is "Latitude (UTM)".}

\item{col}{A color palette function for the surface plot. Default is a custom palette from dark red to yellow to forest green.}

\item{...}{Additional parameters to pass to \code{fields::surface}.}
}
\value{
A surface plot showing spatially interpolated data.
}
\description{
This function creates a surface plot from an interpolated spatial model, with options to customize
plot appearance, grid resolution, and color palette.
}
