% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap.R
\name{.anno_ggseries}
\alias{.anno_ggseries}
\alias{anno_pie}
\alias{anno_ring}
\alias{anno_bar}
\alias{anno_violin}
\alias{anno_boxplot}
\alias{anno_density}
\alias{anno_simple}
\alias{anno_points}
\alias{anno_lines}
\title{Heatmap annotation functions}
\usage{
.anno_ggseries(
  x,
  split_by = NULL,
  group_by,
  column,
  title,
  which = "row",
  palette,
  palcolor = NULL,
  border = TRUE,
  legend.direction,
  show_legend = TRUE,
  .plotting,
  ...
)

anno_pie(
  x,
  split_by = NULL,
  group_by,
  column,
  title,
  which = "row",
  palette,
  palcolor = NULL,
  border = TRUE,
  legend.direction,
  show_legend = TRUE,
  ...
)

anno_ring(
  x,
  split_by = NULL,
  group_by,
  column,
  title,
  which = "row",
  palette,
  palcolor = NULL,
  border = TRUE,
  legend.direction,
  show_legend = TRUE,
  ...
)

anno_bar(
  x,
  split_by = NULL,
  group_by,
  column,
  title,
  which = "row",
  palette,
  palcolor = NULL,
  border = TRUE,
  legend.direction,
  show_legend = TRUE,
  ...
)

anno_violin(
  x,
  split_by = NULL,
  group_by,
  column,
  title,
  which = "row",
  palette,
  palcolor = NULL,
  border = TRUE,
  legend.direction,
  show_legend = TRUE,
  ...
)

anno_boxplot(
  x,
  split_by = NULL,
  group_by,
  column,
  title,
  which = "row",
  palette,
  palcolor = NULL,
  border = TRUE,
  legend.direction,
  show_legend = TRUE,
  ...
)

anno_density(
  x,
  split_by = NULL,
  group_by,
  column,
  title,
  which = "row",
  palette,
  palcolor = NULL,
  border = TRUE,
  legend.direction,
  show_legend = TRUE,
  ...
)

anno_simple(
  x,
  split_by = NULL,
  group_by = NULL,
  column = NULL,
  title,
  which = "row",
  palette,
  palcolor = NULL,
  border = TRUE,
  legend.direction,
  show_legend = TRUE,
  alpha = 1,
  ...
)

anno_points(
  x,
  split_by = NULL,
  group_by,
  column,
  title,
  which = "row",
  palette,
  palcolor = NULL,
  border = TRUE,
  legend.direction,
  show_legend = TRUE,
  alpha = 1,
  ...
)

anno_lines(
  x,
  split_by = NULL,
  group_by,
  column,
  title,
  which = "row",
  palette,
  palcolor = NULL,
  border = TRUE,
  legend.direction,
  show_legend = TRUE,
  alpha = 1,
  add_points = TRUE,
  ...
)
}
\arguments{
\item{x}{A data frame}

\item{split_by}{A character string of the column name to split the data (heatmap)}

\item{group_by}{A character string of the column name to group the data (rows or columns of the heatmap)}

\item{column}{A character string of the column name of the data \code{x} to plot}

\item{title}{A character string to name the legend}

\item{which}{A character string specifying the direction of the annotation. Default is "row".
Other options are "column".}

\item{palette}{A character string specifying the palette of the annotation}

\item{palcolor}{A character vector of colors to override the palette}

\item{border}{A logical value indicating whether to draw the border of the annotation}

\item{legend.direction}{A character string specifying the direction of the legend. Default is "vertical".
Other options are "horizontal".}

\item{show_legend}{A logical value indicating whether to show the legend}

\item{.plotting}{A function to create the plot for each split and each group}

\item{...}{Other arguments passed to \code{ComplexHeatmap::AnnotationFunction}
The parameters passed to \code{row_annotation_params} and \code{column_annotation_params} will be passed here.}

\item{alpha}{A numeric value between 0 and 1 specifying the transparency of the annotation}

\item{add_points}{A logical value indicating whether to add points to the annotation}
}
\description{
Heatmap annotation functions
}
\keyword{internal}
