% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_security.R
\name{api_security_resource_isolation}
\alias{api_security_resource_isolation}
\title{Set up resource isolation for a path}
\usage{
api_security_resource_isolation(
  api,
  path = "/*",
  allowed_site = "same-site",
  forbidden_navigation = c("object", "embed"),
  allow_cors = TRUE
)
}
\arguments{
\item{api}{A plumber2 api object to add the plugin to}

\item{path}{The path that the policy should apply to. routr path syntax
applies, meaning that wilcards and path parameters are allowed.}

\item{allowed_site}{The allowance level to permit. Either \code{cross-site},
\code{same-site}, or \code{same-origin}.}

\item{forbidden_navigation}{A vector of destinations not allowed for
navigational requests. See the \href{https://developer.mozilla.org/en-US/docs/Web/HTTP/Reference/Headers/Sec-Fetch-Dest}{\code{Sec-Fetch-Dest} documentation}
for a description of possible values. The special value \code{"all"} is also
permitted which is the equivalent of passing all values.}

\item{allow_cors}{Should \code{Sec-Fetch-Mode: cors} requests be allowed}
}
\value{
This functions return the \code{api} object allowing for easy chaining
with the pipe
}
\description{
This function adds resource isolation to a path in your API. The function can
be called multiple times to set up resource isolation for multiple
paths, potentially with different settings for each path. You can read in
depth about resource isolation at the
\link[firesafety:ResourceIsolation]{ResourceIsolation} plugin documentation.
}
\section{Using annotation}{
To add resource isolation to a path you can add \verb{@rip <allowed_site>} to a
handler annotation. This will add resource isolation to all endpoints
described in the block. The annotation doesn't allow setting
\code{forbidden_navigation} or \code{allow_cors} and the default values will be used.

\if{html}{\out{<div class="sourceCode">}}\preformatted{#* A handler for /user/<username>
#*
#* @param username:string The name of the user to provide information on
#*
#* @get /user/<username>
#*
#* @response 200:\{name:string, age:integer, hobbies:[string]\} Important
#* information about the user such as their name, age, and hobbies
#*
#* @rip same-origin
#*
function(username) \{
  find_user_in_db(username)
\}
}\if{html}{\out{</div>}}
}

\examples{
# Set up resource isolation for everything inside a user path
api() |>
  api_security_resource_isolation(
    path = "<user>/*"
  )


}
\seealso{
Other security features: 
\code{\link{api_security_cors}()},
\code{\link{api_security_headers}()}
}
\concept{security features}
