% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_objects.R
\name{run_group_meancor}
\alias{run_group_meancor}
\title{Calculate the Mean Correlation of a Sample with Respect to Group}
\usage{
run_group_meancor(omicsData, mintR_groupDF, ignore_singleton_groups = TRUE)
}
\arguments{
\item{omicsData}{an object of the class 'pepData', 'proData', 'metabData', or
'lipidData' usually created
by \code{\link{as.pepData}}, \code{\link{as.proData}}, 
\code{\link{as.metabData}}, or \code{\link{as.lipidData}}, respectively.}

\item{mintR_groupDF}{data.frame created by \code{\link{group_designation}}
with columns for sample.id and group.}

\item{ignore_singleton_groups}{logical indicator of whether to remove
singleton groups or not; defaults to TRUE. A singleton group is a group
consisting of just a single sample. If TRUE, rmd_filter results are
returned only for samples in groups of size greater than 1. This is used
when calculating the correlation.}
}
\value{
data.frame with two elements: Sample.ID, a character vector giving
  the sample names; and Mean_Correlation, a numeric vector giving the mean
  correlation values
}
\description{
This function calculates the mean correlation of a sample with all other
samples that have the same group membership
}
\details{
Correlation calculations use only complete pairwise observations.
}
\author{
Lisa Bramer
}
