% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_nmtables.R
\name{read_nmtables}
\alias{read_nmtables}
\title{Reads NONMEM output tables.}
\usage{
read_nmtables(
  tableFiles = NULL,
  runNo = NULL,
  tabSuffix = "",
  tableNames = c("sdtab", "mutab", "patab", "catab", "cotab", "mytab", "extra", "xptab"),
  quiet = FALSE,
  directory = NULL,
  output_type = c("data.frame", "list"),
  ...
)
}
\arguments{
\item{tableFiles}{NONMEM table files to be read.}

\item{runNo}{Run number.}

\item{tabSuffix}{Table file suffix.}

\item{tableNames}{List of root table names, using the Xpose naming convention
as the default.}

\item{quiet}{Flag for displaying intermediate output.}

\item{directory}{The directory to look for files within.  If NULL, uses the
current directory.}

\item{output_type}{Should output be a "data.frame" where all results are
merged or a "list" of data.frames.}

\item{...}{Passed to each of the read functions (ignored in the functions).}
}
\value{
A data.frame or list of data.frames depending on the
  \code{output_type} argument.
}
\description{
Reads NONMEM output tables.
}
\note{
Adapted from Xpose 4 (\url{https://CRAN.R-project.org/package=xpose4}).
}
\examples{
\dontrun{
tables <- read_nmtables(runNo=315)
}

}
\references{
NONMEM (\url{https://www.iconplc.com/innovation/nonmem/})

Jonsson EN, Karlsson MO. Xpose--an S-PLUS based population
  pharmacokinetic/pharmacodynamic model building aid for NONMEM. Comput
  Methods Programs Biomed. 1999 Jan;58(1):51-64
}
\seealso{
Other NONMEM reading: 
\code{\link{plot_scm}()},
\code{\link{read_nm_all}()},
\code{\link{read_nm_multi_table}()},
\code{\link{read_nmcov}()},
\code{\link{read_nmext}()},
\code{\link{read_nm}()},
\code{\link{read_scm}()}
}
\author{
Bill Denney, Justin Wilkins, Niclas Jonsson, Andrew Hooker
}
\concept{NONMEM reading}
