% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_uncert.R
\name{sample_uncert}
\alias{sample_uncert}
\title{Sample from the multivariate normal distribution to generate new sets of parameters from NONMEM output.}
\usage{
sample_uncert(nmRun, n, seed)
}
\arguments{
\item{nmRun}{Root filename for the NONMEM run (e.g. "run315.xml").}

\item{n}{Number of samples required.}

\item{seed}{Random seed.}
}
\value{
A data frame containing \code{n} samples from the multivariate normal distribution, using
NONMEM typical parameter estimates the NONMEM variance-covariance matrix (from the *.cov file). This
provides \code{n} sets of parameter estimates sampled from the uncertainty distribution, suitable
for simulation under model uncertainty.
}
\description{
Sample from the multivariate normal distribution to generate new sets of parameters from NONMEM output.
}
\examples{
\dontrun{
 nmMatrix <- sample_uncert("run315.xml", 5000, seed=740727)
}

}
\seealso{
NONMEM (\url{https://www.iconplc.com/innovation/nonmem/})
}
\author{
Justin Wilkins, \email{justin.wilkins@occams.com}
}
