% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{run_nldr_viz}
\alias{run_nldr_viz}
\title{Run NLDR Visualization Tool}
\usage{
run_nldr_viz(...)
}
\arguments{
\item{...}{Additional arguments passed to \code{\link[shiny]{shinyApp}}}
}
\value{
A shiny application object that launches the NLDR visualization interface.
}
\description{
Launches the interactive NLDR (Non-Linear Dimensionality Reduction) Visualization Tool
as a shiny application for exploring high-dimensional datasets using t-SNE and UMAP.
}
\details{
The application includes five main tabs:
\itemize{
\item \strong{Dataset Preview}: Upload data and preview dataset characteristics
\item \strong{Non-linear dimension reduction (NLDR)}: Apply t-SNE or UMAP methods
\item \strong{Dynamic Tour}: Explore high-dimensional structure through animated projections
\item \strong{Diagnosing}: Assess embedding quality using quollr package
\item \strong{2-D Layout Comparison}: Compare different NLDR configurations
}
}
\seealso{
\code{\link{nldr_viz_ui}}, \code{\link{nldr_viz_server}}
}
