//
//  RDisplayUtils.hpp
//  POSet
//
//  Created by Alessandro Avellone on 28/02/25.
//  Copyright © 2025 Alessandro Avellone. All rights reserved.
//

#ifndef RDisplayUtils_hpp
#define RDisplayUtils_hpp

#include "displayMessage.h"

//************************************
//************************************
//************************************

class DisplayMessageEvaluationR : public DisplayMessage {
private:
    std::chrono::time_point<std::chrono::high_resolution_clock> __start_clock;
    std::chrono::time_point<std::chrono::high_resolution_clock> __last_output_clock;
    std::uint_fast64_t& __extension_count;
    std::uint_fast64_t& __total_number_of_extensions;
public:
    DisplayMessageEvaluationR(std::uint_fast64_t& total_number_of_extension,
                              std::uint_fast64_t& extension_count,
                              std::uint_fast64_t output_every_sec = 10);
    void Display();
    void Display(std::string);
    void Start();
    void Stop();
private:
    void Output();
};

//************************************
//************************************
//************************************

class DisplayMessageLEGetR : public DisplayMessage {
private:
    std::uint_fast64_t& __extension_count;
    std::uint_fast64_t __total_number_of_extensions;
    bool __expected_output;
    std::chrono::time_point<std::chrono::high_resolution_clock> __start_clock;
    std::chrono::time_point<std::chrono::high_resolution_clock> __last_output_clock;
    std::clock_t __start_tick;
    std::uint_fast64_t EXPECTED_TIME_SEC = 30;
public:
    DisplayMessageLEGetR(
                         std::uint_fast64_t& extension_count,
                         std::uint_fast64_t total_number_of_extension,
                         bool& expected_output,
                         std::uint_fast64_t output_every_sec = 10) :
    DisplayMessage(output_every_sec),
    __extension_count(extension_count),
    __total_number_of_extensions(total_number_of_extension)
    { };
    virtual void Display();
    virtual void Display(std::string);
    virtual void Start() {
        __start_tick = std::clock();
        __start_clock = std::chrono::high_resolution_clock::now();
        __last_output_clock = __start_clock;
        __expected_output = true;
    }
    
    virtual void Stop() {};
};



//************************************
//************************************
//************************************

class DisplayMessageDimensionalityReductionR : public DisplayMessage {
private:
    std::uint_fast64_t& __le_elaborate;
    std::uint_fast64_t __total_le;
    std::chrono::time_point<std::chrono::high_resolution_clock> __start_clock;
    std::chrono::time_point<std::chrono::high_resolution_clock> __last_output_clock;
    std::clock_t __start_tick;
    bool __started;
public:
    DisplayMessageDimensionalityReductionR(std::uint_fast64_t&, std::uint_fast64_t, std::uint_fast64_t);
    virtual void Display();
    virtual void Display(std::string);
    virtual void Start() {
        __start_tick = std::clock();
        __start_clock = std::chrono::high_resolution_clock::now();
        __last_output_clock = __start_clock;
        __started = true;
    }
    virtual void Stop() {
        Output();
        __started = false;
    };
private:
    void Output();
};

#endif /* RDisplayUtils_hpp */
